/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo.rob.impl;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillAppDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigListDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillListDto;
import cn.com.duiba.activity.center.api.enums.ActivityStatusEnum;
import cn.com.duiba.activity.center.api.enums.PushStatusEnum;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobSeckillBo;
import cn.com.duiba.activity.center.biz.domain.PushAppsConfig;
import cn.com.duiba.activity.center.biz.entity.config.CenterConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.config.CenterConfigService;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
import cn.com.duiba.activity.center.biz.service.seckill.DuibaSeckillAppSpecifyService;
import cn.com.duiba.activity.center.biz.service.seckill.DuibaSeckillService;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillService;
import cn.com.duiba.activity.center.common.util.AppLogUtil;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.DuibaSeckillDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteDuibaSeckillService;
import cn.com.duiba.service.remoteservice.RemotePreStockService;
import cn.com.duiba.wolf.redis.RedisClient;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TodayRobSeckillBoImpl
implements TodayRobSeckillBo {
    private static Logger log = LoggerFactory.getLogger(TodayRobSeckillBoImpl.class);
    private static final String REDIS_KEY_PREFIX = "TODAY_ROB_SECKILL";
    private static final Long TODAY_ROB_SECKILL_PARENT_ID = 0L;
    @Autowired
    private TodayRobSeckillService todayRobSeckillService;
    @Autowired
    private CenterConfigService centerConfigService;
    @Autowired
    private DuibaSeckillService duibaSeckillService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private OperatingActivityService operatingActivityService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private RemotePreStockService remotePreStockService;
    @Autowired
    private RemoteDuibaSeckillService remoteDuibaSeckillService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private DeveloperActBlackService developerActBlackService;
    @Autowired
    private DuibaSeckillAppSpecifyService duibaSeckillAppSpecifyService;
    @Autowired
    private SeckillService seckillService;
    @Autowired
    @Qualifier(value="seckillPushThreadPool")
    private ThreadPoolTaskExecutor seckillPushThreadPool;

    @Override
    public void pushSeckillActivity(List<TodayRobSeckillConfigDto> activityList, final List<Long> appIdList) {
        if (CollectionUtils.isEmpty(activityList) || CollectionUtils.isEmpty(appIdList)) {
            AppLogUtil.warn((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd-\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdactivityList={}\ufffd\ufffd\ufffd appIdList={}", (Object[])new Object[]{activityList, appIdList});
            return;
        }
        CenterConfigEntity config = this.centerConfigService.findPushAppsConfig();
        for (TodayRobSeckillConfigDto dto : activityList) {
            TodayRobSeckillConfigEntity entity = this.todayRobSeckillService.findPushedActivity(dto.getActivityId());
            if (entity != null && entity.getPushTime() != null && StringUtils.equals((String)entity.getPushStatus(), (String)PushStatusEnum.SUCC.getCode()) && Objects.equal((Object)entity.getPushAppsVersion(), (Object)config.getVersion())) {
                AppLogUtil.warn((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdactivityId={}", (Object[])new Object[]{dto.getActivityId()});
                continue;
            }
            final DuibaSeckillEntity duibaSeckill = this.duibaSeckillService.find(dto.getActivityId());
            if (duibaSeckill == null) {
                AppLogUtil.error((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdactivityId={}", (Object[])new Object[]{dto.getActivityId()});
                continue;
            }
            if (!Objects.equal((Object)duibaSeckill.getStatus(), (Object)ActivityStatusEnum.STATUS_OPEN.getIntCode())) {
                AppLogUtil.warn((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdactivityId={}\ufffd\ufffd\ufffdstatus={}", (Object[])new Object[]{dto.getActivityId(), duibaSeckill.getStatus()});
                continue;
            }
            final Long todayRobSeckillConfigId = entity == null ? dto.getId() : entity.getId();
            this.seckillPushThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    TodayRobSeckillBoImpl.this.pushToApps(todayRobSeckillConfigId, duibaSeckill, appIdList);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushToApps(Long todayRobSeckillConfigId, DuibaSeckillEntity duibaSeckill, List<Long> appIdList) {
        Long reply = this.redisClient.setnx(REDIS_KEY_PREFIX + duibaSeckill.getId(), duibaSeckill.getId().toString());
        if (reply == 0L) {
            AppLogUtil.warn((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdactivityId={}", (Object[])new Object[]{duibaSeckill.getId()});
            return;
        }
        this.redisClient.expire(REDIS_KEY_PREFIX + duibaSeckill.getId(), 120);
        this.todayRobSeckillService.updatePushStatus(todayRobSeckillConfigId, PushStatusEnum.EXEC);
        PushStatusEnum pushStatus = PushStatusEnum.SUCC;
        try {
            for (Long appId : appIdList) {
                this.doPush(duibaSeckill, appId);
            }
        }
        catch (Exception e) {
            AppLogUtil.error((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, activityId={}", (Object[])new Object[]{duibaSeckill.getId(), e});
            pushStatus = PushStatusEnum.FAILED;
        }
        finally {
            this.redisClient.del(REDIS_KEY_PREFIX + duibaSeckill.getId());
        }
        this.todayRobSeckillService.updatePushStatus(todayRobSeckillConfigId, pushStatus);
    }

    private void doPush(DuibaSeckillEntity duibaSeckill, Long appId) {
        OperatingActivityDto operatingActivity = this.operatingActivityService.findByAppIdAndDuibaSeckillIdAndDeleted(appId, duibaSeckill.getId(), null);
        if (operatingActivity != null) {
            OperatingActivityDto o4u = new OperatingActivityDto(operatingActivity.getId());
            o4u.setDeleted(Boolean.FALSE);
            this.setInsertAndUpdateChildCommonProperties(duibaSeckill, appId, o4u);
            o4u.setStatus(Integer.valueOf(2));
            this.operatingActivityService.update(o4u);
        } else {
            OperatingActivityDto o4i = new OperatingActivityDto(Boolean.TRUE.booleanValue());
            o4i.setAppId(appId);
            this.setInsertAndUpdateChildCommonProperties(duibaSeckill, appId, o4i);
            o4i.setStatus(Integer.valueOf(2));
            o4i.setParentActivityId(TODAY_ROB_SECKILL_PARENT_ID);
            this.operatingActivityService.insert(o4i);
        }
    }

    private void setInsertAndUpdateChildCommonProperties(DuibaSeckillEntity duibaSeckill, Long appId, OperatingActivityDto entity) {
        entity.setType(Integer.valueOf(31));
        entity.setTitle(duibaSeckill.getTitle());
        ItemKey itemKey = this.remoteItemKeyService.getItemKey(duibaSeckill.getItemId(), null, appId);
        Long credits = this.remotePreStockService.calculateCreditsByItemKeyAndDegree(itemKey, null);
        entity.setCredits(credits);
        entity.setRule(duibaSeckill.getRule());
        entity.setActivityId(duibaSeckill.getId());
        entity.setImage(duibaSeckill.getMultiImage());
        entity.setSmallImage(duibaSeckill.getSmallImage());
    }

    @Override
    public PaginationDto<TodayRobSeckillListDto> findTodayRobSeckillList(int pageNum, int pageSize) {
        ArrayList trd = new ArrayList();
        List<TodayRobSeckillEntity> ret = this.todayRobSeckillService.findTodayRobSeckillList(pageNum, pageSize);
        ObjectUtil.convertList(ret, trd, TodayRobSeckillListDto.class);
        ArrayList<Long> todayRobSeckillIds = new ArrayList<Long>();
        for (TodayRobSeckillListDto trs : trd) {
            todayRobSeckillIds.add(trs.getId());
        }
        if (todayRobSeckillIds == null || todayRobSeckillIds.isEmpty()) {
            return new PaginationDto();
        }
        HashMap configMap = Maps.newHashMap();
        ArrayList trsd = new ArrayList();
        ArrayList<Long> todayRobSeckillConfigIds = new ArrayList<Long>();
        ArrayList<Long> seckillIds = new ArrayList<Long>();
        List<TodayRobSeckillConfigEntity> seckillConfigs = this.todayRobSeckillService.findSeckillConfigByIdss(todayRobSeckillIds);
        ObjectUtil.convertList(seckillConfigs, trsd, TodayRobSeckillConfigListDto.class);
        for (TodayRobSeckillConfigListDto trs : trsd) {
            todayRobSeckillConfigIds.add(trs.getId());
            seckillIds.add(trs.getActivityId());
        }
        List seckills = this.remoteDuibaSeckillService.findAllByIds(seckillIds);
        HashMap seckillMap = Maps.newHashMap();
        for (DuibaSeckillDO d : seckills) {
            seckillMap.put(d.getId(), d);
        }
        for (TodayRobSeckillConfigListDto trld : trsd) {
            ArrayList<TodayRobSeckillConfigListDto> l;
            DuibaSeckillDO dsd = (DuibaSeckillDO)seckillMap.get(trld.getActivityId());
            if (dsd != null) {
                trld.setStartDate(DateUtil.getDayStr((Date)dsd.getDateStart()));
                trld.setEndDate(DateUtil.getDayStr((Date)dsd.getDateEnd()));
                trld.setStartTime(DateUtil.getMinuteOnlyStr((Date)dsd.getTimeStart()));
                trld.setEndTime(DateUtil.getMinuteOnlyStr((Date)dsd.getTimeEnd()));
                trld.setTitle(dsd.getTitle());
                if (dsd.getDeleted().booleanValue() || 1 != dsd.getStatus()) {
                    trld.setInvalidFlag(Boolean.valueOf(true));
                }
            }
            if ((l = (ArrayList<TodayRobSeckillConfigListDto>)configMap.get(trld.getTodayRobSeckillId())) == null) {
                l = new ArrayList<TodayRobSeckillConfigListDto>();
                configMap.put(trld.getTodayRobSeckillId(), l);
            }
            l.add(trld);
        }
        for (TodayRobSeckillListDto trs : trd) {
            if (configMap.get(trs.getId()) == null || ((List)configMap.get(trs.getId())).isEmpty()) continue;
            Collections.sort((List)configMap.get(trs.getId()), new Comparator<TodayRobSeckillConfigListDto>(){

                @Override
                public int compare(TodayRobSeckillConfigListDto o1, TodayRobSeckillConfigListDto o2) {
                    return o2.getPayload().compareTo(o1.getPayload());
                }
            });
            trs.setTodayRobSeckillConfigs((List)configMap.get(trs.getId()));
        }
        PaginationDto page = new PaginationDto();
        page.setRows(trd);
        page.setTotalCount(this.todayRobSeckillService.findTodayRobSeckillCount());
        return page;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean seveSeckillConfigs(List<TodayRobSeckillConfigDto> list, TodayRobSeckillDto todayRobSeckillDto) {
        LinkedList<Long> delIdList = new LinkedList<Long>();
        ArrayList<TodayRobSeckillConfigEntity> updateList = new ArrayList<TodayRobSeckillConfigEntity>();
        ArrayList<TodayRobSeckillConfigEntity> insertList = new ArrayList<TodayRobSeckillConfigEntity>();
        boolean flag = false;
        TodayRobSeckillEntity trce = new TodayRobSeckillEntity();
        ObjectUtil.convert((Object)todayRobSeckillDto, (Object)trce);
        if (trce.getId() == null) {
            this.todayRobSeckillService.saveSeckill(trce);
        } else {
            flag = true;
            this.todayRobSeckillService.updateSeckill(trce);
        }
        for (TodayRobSeckillConfigDto trc : list) {
            if (trc.getDeleted().booleanValue()) {
                delIdList.add(trc.getId());
                continue;
            }
            trc.setTodayRobSeckillId(trce.getId());
            TodayRobSeckillConfigEntity pTrc = new TodayRobSeckillConfigEntity();
            ObjectUtil.convert((Object)trc, (Object)pTrc);
            if (trc.getId() == null) {
                insertList.add(pTrc);
                continue;
            }
            updateList.add(pTrc);
        }
        if (delIdList != null && !delIdList.isEmpty()) {
            this.todayRobSeckillService.delSeckillConfigBatch(delIdList);
        }
        if (insertList != null && !insertList.isEmpty()) {
            this.todayRobSeckillService.saveSeckillConfigBatch(insertList);
        } else {
            insertList = new ArrayList();
        }
        if (updateList != null && !updateList.isEmpty()) {
            this.todayRobSeckillService.updateSeckillConfigBatch(updateList);
        } else {
            updateList = new ArrayList();
        }
        if (flag) {
            ArrayList<TodayRobSeckillConfigDto> pushInsertDtoList = new ArrayList<TodayRobSeckillConfigDto>();
            ArrayList pushUpdateDtoList = new ArrayList();
            ObjectUtil.convertList(insertList, pushInsertDtoList, TodayRobSeckillConfigDto.class);
            ObjectUtil.convertList(updateList, pushUpdateDtoList, TodayRobSeckillConfigDto.class);
            CenterConfigEntity entity = this.centerConfigService.findPushAppsConfig();
            PushAppsConfig pushAppsConfig = new PushAppsConfig(entity);
            pushInsertDtoList.addAll(pushUpdateDtoList);
            this.pushSeckillActivity(pushInsertDtoList, pushAppsConfig.getAppIdList());
        }
        return true;
    }

    @Override
    public List<TodayRobSeckillAppDto> findSeckillListByApp(Long appId) {
        CenterConfigEntity entity = this.centerConfigService.findPushAppsConfig();
        PushAppsConfig pushAppsConfig = new PushAppsConfig(entity);
        if (!pushAppsConfig.getAppIdList().contains(appId)) {
            AppLogUtil.info((Logger)log, (String)"app\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdappId={}", (Object[])new Object[]{appId});
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        TodayRobSeckillEntity beforeEntity = this.todayRobSeckillService.findSeckillBeforeNow();
        TodayRobSeckillAppDto beforeAppDto = null;
        AppDO appDO = this.remoteAppService.find(appId);
        List<Long> blackActivityIds = this.developerActBlackService.queryActivityIdsByDeveloperId(appDO.getDeveloperId(), 31);
        List<Long> specifyActivityIds = this.duibaSeckillAppSpecifyService.findActivityIdsByAppId(appId);
        if (beforeEntity != null) {
            beforeAppDto = this.convertDto(appId, beforeEntity, blackActivityIds, specifyActivityIds);
            if (beforeAppDto.isActivityEnd()) {
                if (new Date().before(DateUtil.minutesAddOrSub((Date)beforeAppDto.getStartTime(), (int)15))) {
                    list.add(beforeAppDto);
                }
            } else {
                list.add(beforeAppDto);
            }
        }
        List<Object> entityList = Lists.newArrayList();
        entityList = list.size() > 0 ? this.todayRobSeckillService.findSeckillAfterNow(1) : this.todayRobSeckillService.findSeckillAfterNow(2);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (TodayRobSeckillEntity todayRobSeckillEntity : entityList) {
                TodayRobSeckillAppDto afterAppDto = this.convertDto(appId, todayRobSeckillEntity, blackActivityIds, specifyActivityIds);
                if (!CollectionUtils.isNotEmpty((Collection)afterAppDto.getOperatingActivityList())) continue;
                list.add(afterAppDto);
            }
        }
        if (CollectionUtils.isEmpty((Collection)list) && beforeAppDto != null) {
            list.add(beforeAppDto);
        }
        return list;
    }

    private TodayRobSeckillAppDto convertDto(Long appId, TodayRobSeckillEntity todayRobSeckillEntity, List<Long> blackActivityIds, List<Long> specifyActivityIds) {
        TodayRobSeckillAppDto todayRobSeckillAppDto = (TodayRobSeckillAppDto)BeanUtils.copy((Object)todayRobSeckillEntity, TodayRobSeckillAppDto.class);
        List<TodayRobSeckillConfigEntity> seckillList = this.todayRobSeckillService.findSeckillConfigs(todayRobSeckillAppDto.getId());
        ArrayList seckillIds = Lists.newArrayList();
        for (TodayRobSeckillConfigEntity seckill : seckillList) {
            seckillIds.add(seckill.getActivityId());
        }
        List<DuibaSeckillEntity> duibaSeckillList = this.duibaSeckillService.findAllByIds(seckillIds);
        ArrayList activityIds = Lists.newArrayList();
        int num = 0;
        for (DuibaSeckillEntity duibaSeckill : duibaSeckillList) {
            if (duibaSeckill.isOpenSwitch(DuibaSeckillEntity.SWITCHES_DEV_BLACKLIST) && blackActivityIds.contains(duibaSeckill.getId())) {
                AppLogUtil.info((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdappId={}, activityId={}", (Object[])new Object[]{appId, duibaSeckill.getId()});
                continue;
            }
            if (duibaSeckill.isOpenSwitch(DuibaSeckillEntity.SWITCHES_DIRECT) && !specifyActivityIds.contains(duibaSeckill.getId())) {
                AppLogUtil.info((Logger)log, (String)"app\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdappId={}, activityId={}", (Object[])new Object[]{appId, duibaSeckill.getId()});
                continue;
            }
            activityIds.add(duibaSeckill.getId());
            Date now = new Date();
            if (now.after(DateUtil.getDateTruncate((Date)DateUtil.daysAddOrSub((Date)duibaSeckill.getDateEnd(), (int)1))) || DateUtil.compareTime((Date)now, (Date)duibaSeckill.getTimeEnd()) > 0) {
                AppLogUtil.info((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdappId={}, activityId={}, dateEnd={}, timeEnd={}", (Object[])new Object[]{appId, duibaSeckill.getId(), duibaSeckill.getDateEnd(), duibaSeckill.getTimeEnd()});
                continue;
            }
            Long stock = this.seckillService.getStock(appId, duibaSeckill);
            if (stock < 1L) {
                AppLogUtil.info((Logger)log, (String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdappId={}, activityId={}", (Object[])new Object[]{appId, duibaSeckill.getId()});
                continue;
            }
            ++num;
        }
        todayRobSeckillAppDto.setActivityEnd(num == 0);
        List<OperatingActivityDto> operatingActivityList = this.operatingActivityService.findDuibaSeckillByAppIdAndActivityId(appId, activityIds, 31);
        operatingActivityList = this.orderBySeckillIds(operatingActivityList, seckillIds);
        todayRobSeckillAppDto.setOperatingActivityList(operatingActivityList);
        return todayRobSeckillAppDto;
    }

    private List<OperatingActivityDto> orderBySeckillIds(List<OperatingActivityDto> operatingActivityList, List<Long> seckillIds) {
        HashMap<Long, OperatingActivityDto> map = new HashMap<Long, OperatingActivityDto>();
        for (OperatingActivityDto dto : operatingActivityList) {
            if (map.get(dto.getActivityId()) != null || dto.getStatus() != 2) continue;
            map.put(dto.getActivityId(), dto);
        }
        ArrayList list = Lists.newArrayList();
        for (Long seckillId : seckillIds) {
            if (map.get(seckillId) == null) continue;
            list.add(map.get(seckillId));
        }
        return list;
    }

    @Override
    public Boolean enableTodayRobSeckill(long todayRobSeckillId, boolean enable) {
        if (enable) {
            ArrayList<TodayRobSeckillConfigDto> pushList = new ArrayList<TodayRobSeckillConfigDto>();
            List<TodayRobSeckillConfigEntity> seckillList = this.todayRobSeckillService.findSeckillConfigs(todayRobSeckillId);
            ObjectUtil.convertList(seckillList, pushList, TodayRobSeckillConfigDto.class);
            CenterConfigEntity entity = this.centerConfigService.findPushAppsConfig();
            PushAppsConfig pushAppsConfig = new PushAppsConfig(entity);
            this.pushSeckillActivity(pushList, pushAppsConfig.getAppIdList());
        }
        this.todayRobSeckillService.enableTodayRobSeckill(todayRobSeckillId, enable);
        return true;
    }
}

