/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo.stock;

import cn.com.duiba.activity.center.api.dto.singlelottery.AppSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryAppSpecifyDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.SingleLotteryStockConsumeDto;
import cn.com.duiba.activity.center.biz.service.singlelottery.DuibaSingleLotteryService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryService;
import cn.com.duiba.activity.center.biz.service.singlelottery.SingleLotteryStockConsumeService;
import cn.com.duiba.service.exception.BusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SingleLotteryStockConsumeBo {
    private static Logger log = LoggerFactory.getLogger(SingleLotteryStockConsumeBo.class);
    @Autowired
    private DuibaSingleLotteryService duibaSingleLotteryService;
    @Autowired
    private SingleLotteryStockConsumeService singleLotteryStockConsumeService;
    @Autowired
    private SingleLotteryService singleLotteryService;

    @Transactional(value="credits")
    public void consumeDuibaSingleLotteryStock(Long duibaSingleLotteryId, Long appId, Integer optionType, String bizId, String bizSource) throws BusinessException {
        int ret;
        String optionTypeStr = null;
        DuibaSingleLotteryDto duibaSingle = this.duibaSingleLotteryService.findForupdate(duibaSingleLotteryId);
        if (null == duibaSingle) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (optionType == 1) {
            if (duibaSingle.getMainItemRemaining() <= 0) {
                throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            ret = this.duibaSingleLotteryService.reduceMainItemRemaining(duibaSingle.getId());
            if (ret < 1) {
                throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            optionTypeStr = "main";
        } else if (optionType == 2) {
            if (duibaSingle.getInciteItemRemaining() <= 0) {
                throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            ret = this.duibaSingleLotteryService.reduceInciteItemRemaining(duibaSingle.getId());
            if (ret < 1) {
                throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            optionTypeStr = "incite";
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDto consume = new SingleLotteryStockConsumeDto(true);
        consume.setRelationId(duibaSingle.getId());
        consume.setRelationType("duiba");
        consume.setAppId(appId);
        consume.setAction("pay");
        consume.setBizId(bizId);
        consume.setOptionType(optionTypeStr);
        consume.setBizSource(bizSource);
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(consume);
    }

    @Transactional(value="credits")
    public void paybackDuibaSingleLotteryStock(String bizId, String bizSource) throws BusinessException {
        int ret;
        SingleLotteryStockConsumeDto consume = this.singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            return;
        }
        DuibaSingleLotteryDto duibaSingle = this.duibaSingleLotteryService.findForupdate(consume.getRelationId());
        if (null == duibaSingle) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            return;
        }
        if (consume.getOptionType().equals("main") ? (ret = this.duibaSingleLotteryService.addMainItemRemaining(duibaSingle.getId())) < 1 : consume.getOptionType().equals("incite") && (ret = this.duibaSingleLotteryService.addInciteItemRemaining(duibaSingle.getId())) < 1) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDto detail = new SingleLotteryStockConsumeDto(true);
        detail.setRelationId(consume.getRelationId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(consume.getAppId());
        detail.setAction("back");
        detail.setBizId(consume.getBizId());
        detail.setBizSource(consume.getBizSource());
        detail.setOptionType(consume.getOptionType());
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(detail);
    }

    @Transactional(value="credits")
    public void consumeSingleLotterySpecifyStock(Long duibaSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException {
        SingleLotteryAppSpecifyDto specify = this.duibaSingleLotteryService.findSpecifyByDuibaSingleLotteryAndApp(duibaSingleLotteryId, appId);
        if (null == specify) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if ((specify = this.duibaSingleLotteryService.findSpecifyForupdate(specify.getId())).getRemaining() <= 0) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        int ret = this.duibaSingleLotteryService.reduceSpecifyAppRemaining(duibaSingleLotteryId, appId);
        if (ret < 1) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDto consume = new SingleLotteryStockConsumeDto(true);
        consume.setRelationId(specify.getId());
        consume.setRelationType("specify");
        consume.setAppId(appId);
        consume.setAction("pay");
        consume.setBizId(bizId);
        consume.setOptionType("main");
        consume.setBizSource(bizSource);
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(consume);
    }

    @Transactional(value="credits")
    public void paybackSingleLotterySpecifyStock(String bizId, String bizSource) throws BusinessException {
        SingleLotteryStockConsumeDto consume = this.singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            return;
        }
        SingleLotteryAppSpecifyDto specify = this.duibaSingleLotteryService.findSpecifyForupdate(consume.getRelationId());
        if (null == specify) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            return;
        }
        int ret = this.duibaSingleLotteryService.addSpecifyAppRemaining(specify.getDuibaSingleLotteryId(), specify.getAppId());
        if (ret < 1) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDto detail = new SingleLotteryStockConsumeDto(true);
        detail.setRelationId(specify.getId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(specify.getAppId());
        detail.setAction("back");
        detail.setBizId(bizId);
        detail.setOptionType(consume.getOptionType());
        detail.setBizSource(consume.getBizSource());
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(detail);
    }

    @Transactional(value="credits")
    public void consumeDevSingleLotteryStock(Long appSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException {
        AppSingleLotteryDto appSingle = this.singleLotteryService.findForupdate(appSingleLotteryId);
        if (null == appSingle) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (appSingle.getMainAppItemRemaining() <= 0) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        int ret = this.singleLotteryService.reduceMainAppItemRemaining(appSingle.getId());
        if (ret < 1) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDto consume = new SingleLotteryStockConsumeDto(true);
        consume.setRelationId(appSingle.getId());
        consume.setRelationType("app");
        consume.setAppId(appId);
        consume.setAction("pay");
        consume.setBizId(bizId);
        consume.setOptionType("main");
        consume.setBizSource(bizSource);
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(consume);
    }

    @Transactional(value="credits")
    public void pabackDevSingleLoteryStock(String bizId, String bizSource) throws BusinessException {
        SingleLotteryStockConsumeDto consume = this.singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            return;
        }
        AppSingleLotteryDto appSingle = this.singleLotteryService.findForupdate(consume.getRelationId());
        if (null == appSingle) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            return;
        }
        int ret = this.singleLotteryService.addMainAppItemRemaining(appSingle.getId());
        if (ret < 1) {
            throw new BusinessException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDto detail = new SingleLotteryStockConsumeDto(true);
        detail.setRelationId(consume.getRelationId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(consume.getAppId());
        detail.setAction("back");
        detail.setBizId(consume.getBizId());
        detail.setOptionType(consume.getOptionType());
        detail.setBizSource(consume.getBizSource());
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(detail);
    }
}

