/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.dao;

import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.wolf.spring.datasource.AutoRoutingDataSource;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DelegatingDataSource;

public abstract class ActivityBaseDao {
    private static final Logger log = LoggerFactory.getLogger(ActivityBaseDao.class);
    @Resource(name="creditsSqlSessionTemplate")
    private SqlSessionTemplate creditsSqlSessionTemplate;
    @Resource(name="creditsActivitySqlSessionTemplate")
    private SqlSessionTemplate creditsActivitySqlSessionTemplate;
    @Resource(name="creditsGameSqlSessionTemplate")
    private SqlSessionTemplate creditsGameSqlSessionTemplate;
    @Resource(name="quizzSqlSessionTemplate")
    private SqlSessionTemplate quizzSqlSessionTemplate;
    @Resource(name="consumerQuizzSqlSessionTemplate")
    private SqlSessionTemplate consumerQuizzSqlSessionTemplate;
    @Resource(name="appQuizzSqlSessionTemplate")
    protected SqlSessionTemplate appQuizzSqlSessionTemplate;
    @Resource(name="seckillAppSqlSessionTemplate")
    private SqlSessionTemplate seckillAppSqlSessionTemplate;
    @Resource(name="ngameSqlSessionTemplate")
    private SqlSessionTemplate ngameSqlSessionTemplate;
    @Resource(name="ngameAppSqlSessionTemplate")
    private SqlSessionTemplate ngameAppSqlSessionTemplate;
    @Resource(name="ngameConSqlSessionTemplate")
    private SqlSessionTemplate ngameConSqlSessionTemplate;
    @Resource(name="mngHdtoolSqlSessionTemplate")
    private SqlSessionTemplate mngHdtoolSqlSessionTemplate;
    @Resource(name="appHdtoolSqlSessionTemplate")
    private SqlSessionTemplate appHdtoolSqlSessionTemplate;
    @Resource(name="creditsHdtoolSqlSessionTemplate")
    private SqlSessionTemplate creditsHdtoolSqlSessionTemplate;
    @Resource(name="guessSqlSessionTemplate")
    private SqlSessionTemplate guessSqlSessionTemplate;
    @Resource(name="consumerGuessSqlSessionTemplate")
    private SqlSessionTemplate consumerGuessSqlSessionTemplate;
    @Resource(name="appGuessSqlSessionTemplate")
    private SqlSessionTemplate appGuessSqlSessionTemplate;
    @Resource(name="seckillSqlSessionTemplate")
    private SqlSessionTemplate seckillSqlSessionTemplate;

    private SqlSessionTemplate getSqlSessionTemplate(boolean isForceUseMasterDataSource) {
        DatabaseSchema databaseSchema = this.chooseSchema();
        if (databaseSchema == null) {
            throw new NullPointerException("please set databaseSchema in class:" + this.getClass().getName());
        }
        SqlSessionTemplate sqlSessionTemplate = null;
        switch (databaseSchema) {
            case CREDITS: {
                sqlSessionTemplate = this.creditsSqlSessionTemplate;
                break;
            }
            case NGAME: {
                sqlSessionTemplate = this.ngameSqlSessionTemplate;
                break;
            }
            case NGAME_APP: {
                sqlSessionTemplate = this.ngameAppSqlSessionTemplate;
                break;
            }
            case NGAME_CON: {
                sqlSessionTemplate = this.ngameConSqlSessionTemplate;
                break;
            }
            case SECKILL_APP: {
                sqlSessionTemplate = this.seckillAppSqlSessionTemplate;
                break;
            }
            case CREDITS_GAME: {
                sqlSessionTemplate = this.creditsGameSqlSessionTemplate;
                break;
            }
            case QUIZZ: {
                sqlSessionTemplate = this.quizzSqlSessionTemplate;
                break;
            }
            case QUIZZ_CONSUMER: {
                sqlSessionTemplate = this.consumerQuizzSqlSessionTemplate;
                break;
            }
            case QUIZZ_APP: {
                sqlSessionTemplate = this.appQuizzSqlSessionTemplate;
                break;
            }
            case SECKILL: {
                sqlSessionTemplate = this.seckillSqlSessionTemplate;
                break;
            }
            case CREDITS_ACTIVITY: {
                sqlSessionTemplate = this.creditsActivitySqlSessionTemplate;
                break;
            }
            case MNG_HDTOOL: {
                sqlSessionTemplate = this.mngHdtoolSqlSessionTemplate;
                break;
            }
            case APP_HDTOOL: {
                sqlSessionTemplate = this.appHdtoolSqlSessionTemplate;
                break;
            }
            case CREDITS_HDTOOL: {
                sqlSessionTemplate = this.creditsHdtoolSqlSessionTemplate;
                break;
            }
            case GUESS: {
                sqlSessionTemplate = this.guessSqlSessionTemplate;
                break;
            }
            case GUESS_CON: {
                sqlSessionTemplate = this.consumerGuessSqlSessionTemplate;
                break;
            }
            case GUESS_APP: {
                sqlSessionTemplate = this.appGuessSqlSessionTemplate;
                break;
            }
            default: {
                throw new NullPointerException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdsqlSessionTemplate,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
        }
        DataSource ds = sqlSessionTemplate.getSqlSessionFactory().getConfiguration().getEnvironment().getDataSource();
        if (ds instanceof DelegatingDataSource) {
            ds = ((DelegatingDataSource)ds).getTargetDataSource();
        }
        if (ds instanceof AutoRoutingDataSource) {
            AutoRoutingDataSource autoRoutingDataSource = (AutoRoutingDataSource)ds;
            autoRoutingDataSource.determineCurrentLookupKeyByItSelf(isForceUseMasterDataSource);
        }
        return sqlSessionTemplate;
    }

    protected abstract DatabaseSchema chooseSchema();

    public int insert(String statement) {
        return this.getSqlSessionTemplate(true).insert(this.addNameSpace(statement));
    }

    public int delete(String statement) {
        return this.getSqlSessionTemplate(true).delete(this.addNameSpace(statement));
    }

    public int update(String statement) {
        return this.getSqlSessionTemplate(true).update(this.addNameSpace(statement));
    }

    public int delete(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).delete(this.addNameSpace(statement), parameter);
    }

    public <E> List<E> selectList(String statement, Object parameter, RowBounds rowBounds) {
        return this.getSqlSessionTemplate(false).selectList(this.addNameSpace(statement), parameter, rowBounds);
    }

    public void select(String statement, ResultHandler handler) {
        this.getSqlSessionTemplate(false).select(this.addNameSpace(statement), handler);
    }

    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.getSqlSessionTemplate(false).selectOne(this.addNameSpace(statement), parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.getSqlSessionTemplate(false).selectMap(this.addNameSpace(statement), parameter, mapKey);
    }

    public int insert(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).insert(this.addNameSpace(statement), parameter);
    }

    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey, RowBounds rowBounds) {
        return this.getSqlSessionTemplate(false).selectMap(this.addNameSpace(statement), parameter, mapKey, rowBounds);
    }

    public void select(String statement, Object parameter, RowBounds rowBounds, ResultHandler handler) {
        this.getSqlSessionTemplate(false).select(this.addNameSpace(statement), parameter, rowBounds, handler);
    }

    public <E> List<E> selectList(String statement) {
        return this.getSqlSessionTemplate(false).selectList(this.addNameSpace(statement));
    }

    public void select(String statement, Object parameter, ResultHandler handler) {
        this.getSqlSessionTemplate(false).select(this.addNameSpace(statement), parameter, handler);
    }

    public <K, V> Map<K, V> selectMap(String statement, String mapKey) {
        return this.getSqlSessionTemplate(false).selectMap(this.addNameSpace(statement), mapKey);
    }

    public int update(String statement, Object parameter) {
        return this.getSqlSessionTemplate(true).update(this.addNameSpace(statement), parameter);
    }

    public <T> T selectOne(String statement) {
        return (T)this.getSqlSessionTemplate(false).selectOne(this.addNameSpace(statement));
    }

    public <E> List<E> selectList(String statement, Object parameter) {
        return this.getSqlSessionTemplate(false).selectList(this.addNameSpace(statement), parameter);
    }

    protected String addNameSpace(String method) {
        return this.getClass().getName() + "." + method;
    }
}

