/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.kafka;

import cn.com.duiba.activity.center.biz.kafka.AdActivityMessage;
import cn.com.duiba.activity.center.biz.kafka.MessageService;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class AdActivityMQSend {
    private static Logger log = LoggerFactory.getLogger(AdActivityMQSend.class);
    @Resource
    private MessageService messageService;
    @Resource
    private TopicConstant topicConstant;

    public void adActivityInsertSync(Long activityId, Integer activityType, String activityName, Integer activityStatus, String tag) {
        this.adActivitySendDataSync(this.generatorMessage(activityId, activityType, activityName, activityStatus, tag, "insert"));
    }

    public void adActivityUpdateSync(Long activityId, Integer activityType, String activityName, Integer activityStatus, String tag) {
        this.adActivitySendDataSync(this.generatorMessage(activityId, activityType, activityName, activityStatus, tag, "update"));
    }

    public void adActivityDeleteSync(Long activityId, Integer activityType) {
        this.adActivitySendDataSync(this.generatorMessage(activityId, activityType, null, null, null, "delete"));
    }

    private AdActivityMessage generatorMessage(Long activityId, Integer activityType, String activityName, Integer activityStatus, String tag, String actionType) {
        AdActivityMessage message = new AdActivityMessage();
        message.setActivityId(activityId);
        message.setActivityType(activityType);
        message.setActivityName(activityName);
        message.setActivityStatus(activityStatus);
        message.setTag(tag);
        message.setAction(actionType);
        return message;
    }

    public void adActivitySendDataSync(AdActivityMessage message) {
        try {
            log.error("adActivitySendDataSync : " + message.toString());
            this.messageService.sendMsg(this.topicConstant.getTopicHdtoolDataSync(), message);
        }
        catch (Exception e) {
            log.error("adActivity send message is error," + message.toString(), (Throwable)e);
        }
    }
}

