/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.kafka.MessageService;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.activity.center.biz.tools.AssembleTool;
import cn.com.duiba.activity.center.biz.tools.service.ActualPriceCalService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.activity.center.biz.utils.MemLock;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.dcommons.flowwork.ActivityLotteryFlowworkService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ConsumerCreditsServiceImpl
implements ConsumerCreditsService {
    private static Logger log = LoggerFactory.getLogger(ConsumerCreditsServiceImpl.class);
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConsumerCreditsCallback consumerCreditsCallback;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private TimeLimitService timeLimitService;
    @Autowired
    private ItemKeyStockServcie itemKeyStockServcie;
    @Autowired
    private RemoteAddrLimitService remoteAddrLimitService;
    @Autowired
    private ActualPriceCalService actualPriceCalService;
    @Autowired
    private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired
    @Qualifier(value="notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    @Autowired
    private ActivityLotteryFlowworkService activityLotteryFlowworkService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;

    @Override
    public void asyncConsumerCredits(Long consumerId, String orderNum, String transer, String ip, String description) {
        DubboResult order = this.remoteActivityOrderService.findByOrderNum(orderNum);
        if (!order.isSuccess() || order.getResult() == null) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            this.onCreditsFail(message, new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd"));
            return;
        }
        if (((ActivityOrderDto)order.getResult()).getConsumeCreditsStatus() != 1) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            this.onCreditsSuccess(message);
            return;
        }
        if (((ActivityOrderDto)order.getResult()).getConsumeCredits() <= 0L) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            this.onCreditsSuccess(message);
            return;
        }
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        AppDO app = this.remoteAppService.find(consumer.getAppId());
        CreditConsumeParams p = new CreditConsumeParams();
        p.setAppKey(app.getAppKey());
        p.setCredits(((ActivityOrderDto)order.getResult()).getConsumeCredits());
        p.setOrderNum("activity-" + ((ActivityOrderDto)order.getResult()).getOrderNum());
        p.setUid(consumer.getPartnerUserId());
        p.setTimestamp(new Date());
        p.setType(((ActivityOrderDto)order.getResult()).getActivityType());
        p.setIp(((ActivityOrderDto)order.getResult()).getIp());
        p.setFacePrice(Integer.valueOf(0));
        p.setActualPrice(Integer.valueOf(0));
        p.setDescription(description);
        if (StringUtils.isNotBlank((CharSequence)transer)) {
            p.setTransfer(transer);
        }
        Map map = p.toRequestMap(app.getAppSecret());
        CreditsMessage mq = new CreditsMessage();
        mq.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        mq.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
        mq.setConsumerId(((ActivityOrderDto)order.getResult()).getConsumerId().toString());
        mq.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
        mq.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
        HashMap params = Maps.newHashMap();
        params.put("ip", ip);
        mq.setParams((Map)params);
        if ("baiduyun".equals(Environment.getPlace())) {
            mq.setHttpUrl(app.getCreditsConsumeRequestUrl());
            mq.setHttpType("post");
            mq.setAuthParams(map);
        } else {
            String url = AssembleTool.assembleUrl(app.getCreditsConsumeRequestUrl(), map);
            mq.setHttpUrl(url);
            mq.setHttpType("get");
        }
        String str = JSONObject.toJSONString((Object)mq);
        try {
            log.error("->>\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdkafka\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd," + str);
            this.messageService.sendMsg(this.topicConstant.getTopicConsumerCredits(), str, 2000);
        }
        catch (Exception e) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap paramss = Maps.newHashMap();
            paramss.put("ip", ip);
            message.setParams((Map)paramss);
            this.onCreditsFail(message, e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreditsFail(CreditsCallbackMessage message, Exception exception) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        try {
            ActivityOrderDto o4u = new ActivityOrderDto();
            if (exception instanceof DeveloperConsumeFailedException && ((DeveloperConsumeFailedException)exception).getNormalFail().booleanValue()) {
                o4u.setError4admin("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + exception.getMessage());
                o4u.setError4developer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                o4u.setError4consumer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            } else {
                o4u.setError4admin("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + exception.getMessage());
                o4u.setError4developer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + exception.getMessage());
                o4u.setError4consumer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            this.remoteActivityOrderService.consumeCreditsFail(order.getOrderNum(), null, null, null, null, null, null, null, null, null, o4u.getError4admin(), o4u.getError4developer(), o4u.getError4consumer());
            if (order.getConsumeCredits() > 0L) {
                this.remoteConsumerService.increaseCredits(order.getConsumerId(), order.getConsumeCredits());
            }
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd:", (Throwable)e);
        }
        finally {
            this.complete(order.getOrderNum());
            DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreditsSuccess(CreditsCallbackMessage message) {
        block13: {
            String ip = (String)message.getParams().get("ip");
            ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
            List<Object> options = Lists.newArrayList();
            if (order.getActivityType().equals("rob")) {
                options = this.activityPrizeOptionService.queryActivityOptionsByConfigId(order.getDuibaActivityId(), ActivityPrizeOptionDto.Activity_Type_Rob);
            }
            ActivityPrizeOptionDto winOption = this.randomPrize(order.getDuibaActivityId(), order.getActivityType(), options);
            try {
                winOption = this.winOptionCheck(order, winOption, options);
                this.doWinPrize(order, winOption, options, ip);
            }
            catch (Exception e) {
                log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd:\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
                LogUtil.logTodayKan((String)("ConsumerCreditsServiceImpl onCreditsSuccess \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd winOption===>" + JSONObject.toJSONString((Object)winOption)));
                try {
                    if (winOption.getPrizeType().equals("object")) {
                        LogUtil.logTodayKan((String)("ConsumerCreditsServiceImpl onCreditsSuccess \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd order===>" + JSONObject.toJSONString((Object)order)));
                        ActivityPrizeOptionDto option = this.awardCoupon(order.getDuibaActivityId(), order.getActivityType(), options);
                        winOption = this.winOptionCheck(order, option, options);
                        this.doWinPrize(order, winOption, options, ip);
                        break block13;
                    }
                    if (!winOption.getPrizeType().equals("coupon")) break block13;
                    LogUtil.logTodayKan((String)("ConsumerCreditsServiceImpl onCreditsSuccess \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd order===>" + JSONObject.toJSONString((Object)order)));
                    try {
                        ActivityPrizeOptionDto option = this.awardThanks(order.getDuibaActivityId(), order.getActivityType());
                        this.doWinPrize(order, option, options, ip);
                    }
                    catch (Exception e2) {
                        log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd: \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e2);
                    }
                }
                catch (Exception e1) {
                    log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd:", (Throwable)e1);
                    LogUtil.logTodayKan((String)("ConsumerCreditsServiceImpl onCreditsSuccess finally \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd order===>" + JSONObject.toJSONString((Object)order)));
                    try {
                        ActivityPrizeOptionDto option = this.awardThanks(order.getDuibaActivityId(), order.getActivityType());
                        this.doWinPrize(order, option, options, ip);
                    }
                    catch (Exception e3) {
                        log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd: \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ", (Throwable)e3);
                    }
                }
            }
            finally {
                this.complete(order.getOrderNum());
                ActivityOrderDto orderNew = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
                DuibaEventsDispatcher.get().dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(orderNew));
            }
        }
    }

    private ActivityPrizeOptionDto winOptionCheck(ActivityOrderDto order, ActivityPrizeOptionDto winOption, List<ActivityPrizeOptionDto> options) {
        boolean optionCheck;
        boolean itemCheck;
        while (!(itemCheck = this.validItemKeyCheck(order, winOption, optionCheck = this.validOptionCheck(order, winOption)))) {
            LogUtil.logTodayKan((String)("winOptionCheck \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd winOption===>" + JSONObject.toJSONString((Object)winOption)));
            if (winOption.getPrizeType().equals("coupon")) {
                LogUtil.logTodayKan((String)("winOptionCheck coupon failed winOption===>" + JSONObject.toJSONString((Object)winOption)));
                winOption = this.awardThanks(order.getDuibaActivityId(), order.getActivityType());
                return winOption;
            }
            winOption = this.awardCoupon(order.getDuibaActivityId(), order.getActivityType(), options);
            LogUtil.logTodayKan((String)("winOptionCheck awardCoupon success winOption===>" + JSONObject.toJSONString((Object)winOption)));
        }
        return winOption;
    }

    public void doWinPrize(ActivityOrderDto order, ActivityPrizeOptionDto winOption, List<ActivityPrizeOptionDto> options, String ip) throws Exception {
        Long couponId = null;
        ActivityOrderSyncEvent.ActivityOrderPluginContext context = new ActivityOrderSyncEvent.ActivityOrderPluginContext();
        MemLock lock = new MemLock();
        lock.setLocked(false);
        try {
            DubboResult result;
            if (winOption.getId() != null) {
                lock = this.frequentExchangeLimit.lockPrize(order.getDuibaActivityId(), order.getActivityType(), winOption.getId());
                if (lock.isLocked()) {
                    DuibaEventsDispatcher.get().triggerBeforeActivityOrderComplete(order, winOption, context);
                    Object obj = context.getAttribute("couponId");
                    if (null != obj) {
                        couponId = (Long)obj;
                    }
                } else {
                    throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                }
            }
            if (!(result = this.remoteActivityOrderService.consumeCreditsSuccess(order.getOrderNum(), winOption.getId(), winOption.getPrizeName(), winOption.getPrizeType(), winOption.getFacePrice(), winOption.getAppItemId(), winOption.getItemId(), winOption.getgId(), winOption.getgType(), couponId)).isSuccess() || result.getResult() == null || !((Boolean)result.getResult()).booleanValue()) {
                throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            this.remoteActivityOrderService.exchangeStatusToWait(order.getOrderNum());
        }
        catch (Exception e) {
            if (lock.isLocked()) {
                DuibaEventsDispatcher.get().triggerOnActivityOrderCompleteException(order, winOption, e, context);
            }
            log.error("className: " + this.getClass().getName() + " method: doWinPrize", (Throwable)e);
            throw e;
        }
        finally {
            if (lock.isLocked()) {
                this.frequentExchangeLimit.unlockPrize(order.getDuibaActivityId(), order.getActivityType(), winOption.getId());
            }
            if (order.getActivityType().equals("rob")) {
                this.todayRobConfigService.updateVisitTime(order.getDuibaActivityId());
            }
        }
        if (!winOption.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
            this.activityLotteryFlowworkService.insertCosumerExchanageRecord(order.getConsumerId(), order.getOrderNum(), null, winOption.getPrizeType());
        }
        if (winOption.getPrizeType().equals("coupon")) {
            try {
                this.activityLotteryFlowworkService.autoTakePrize(order.getOrderNum(), order.getConsumerId(), order.getAppId(), ip, null);
            }
            catch (Exception e) {
                log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            }
        }
    }

    public void complete(String orderNum) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        this.insertHdtoolOrderNotifyQueueIfNesscery(order);
        if (order.getConsumeCreditsStatus() == 2) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == 3) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail, order));
        }
    }

    private void insertHdtoolOrderNotifyQueueIfNesscery(ActivityOrderDto order) {
        try {
            if (order.getConsumeCredits() <= 0L) {
                return;
            }
            if (order.getConsumeCreditsStatus() == 1) {
                return;
            }
            ConsumerDO consumer = this.remoteConsumerService.find(order.getConsumerId());
            NotifyQueueDO nq = new NotifyQueueDO();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum("activity-" + order.getOrderNum());
            if (order.getError4developer() != null) {
                nq.setError4developer(order.getError4developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getDuibaActivityId());
            nq.setRelationType("rob");
            nq.setTimes(Integer.valueOf(0));
            nq.setResult(Boolean.valueOf(order.getConsumeCreditsStatus() == 2));
            this.notifyQueueDAO.insert(nq);
            this.notifyCenterServiceClient.notifyImmediately(nq.getId());
        }
        catch (Exception e) {
            log.error("insertHdtoolOrderNotifyQueueIfNesscery error", (Throwable)e);
        }
    }

    public boolean validOptionCheck(ActivityOrderDto order, ActivityPrizeOptionDto prize) {
        DubboResult stockNum;
        if (prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
            return true;
        }
        if (prize.getMinComein() != null) {
            int joinTime = 0;
            if (order.getActivityType().equals("rob")) {
                TodayRobConfigDto dto = this.todayRobConfigService.find(order.getDuibaActivityId());
                joinTime = dto.getVisitTime();
            }
            if (joinTime < prize.getMinComein()) {
                return false;
            }
        }
        ActPreStockDto preStock = this.actPreStockSerivce.findPreStockByApp(prize.getId(), ActivityPrizeOptionDto.Activity_Type_Rob, order.getAppId());
        Long stockId = prize.getStockId();
        if (null != preStock && preStock.getPrizeQuantity() != null) {
            stockId = preStock.getPrizeQuantity();
        }
        return (stockNum = this.remoteStockService.find(stockId.longValue())).isSuccess() && null != stockNum.getResult() && (Long)stockNum.getResult() > 0L;
    }

    public boolean validItemKeyCheck(ActivityOrderDto order, ActivityPrizeOptionDto prize, boolean check) {
        if (!check) {
            return false;
        }
        if (prize.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
            return true;
        }
        ItemKey itemKey = this.remoteItemKeyService.getItemKeyIncludeDeleted(prize.getItemId(), prize.getAppItemId(), order.getAppId());
        if (itemKey == null) {
            return false;
        }
        if (itemKey.getItem() != null && (!itemKey.getItem().getEnable().booleanValue() || itemKey.getItem().getDeleted().booleanValue())) {
            return false;
        }
        if (this.timeLimitService.isLimitItem(itemKey.getItem())) {
            return false;
        }
        if (!itemKey.getApp().isAppSwitch(7)) {
            if (null != itemKey.getItem() && itemKey.getItem().getType().equals("coupon")) {
                if (!itemKey.getItem().getId().equals(191L)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if ((prize.getPrizeType().equals("object") || prize.getPrizeType().equals("coupon")) && this.itemKeyStockServcie.findRemaining(itemKey) <= 0) {
            return false;
        }
        if (!this.itemKeyStockServcie.couponBatchCheck(itemKey)) {
            return false;
        }
        if ("object".equals(itemKey.getItemType()) && (itemKey.isItemMode() || itemKey.isDuibaAppItemMode())) {
            if (itemKey.getItem().getValidEndDate() != null && new Date().after(itemKey.getItem().getValidEndDate())) {
                return false;
            }
            if (itemKey.getItem().getAutoOffDate() != null && new Date().after(itemKey.getItem().getAutoOffDate())) {
                return false;
            }
        }
        List itemKeyVOs = Lists.newArrayList((Object[])new ItemKeyVO[]{new ItemKeyVO(itemKey)});
        return !(itemKeyVOs = this.remoteAddrLimitService.mobileIndexAddrLimitFilter(itemKeyVOs, order.getIp())).isEmpty();
    }

    private ActivityPrizeOptionDto randomPrize(Long activityId, String activityType, List<ActivityPrizeOptionDto> options) {
        double totalRate = 0.0;
        ArrayList validOptions = Lists.newArrayList();
        for (ActivityPrizeOptionDto option : options) {
            if (!StringUtils.isNotBlank((CharSequence)option.getRate()) || !(Double.valueOf(option.getRate()) > 1.0E-5)) continue;
            totalRate += Double.valueOf(option.getRate()).doubleValue();
            validOptions.add(option);
        }
        if (totalRate > 100.0) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd100%,duibaActivityId=" + activityId + ",activityType=" + activityType);
            return this.awardCoupon(activityId, activityType, options);
        }
        Collections.shuffle(validOptions);
        double randomNumber = Math.random() * 100.0;
        ActivityPrizeOptionDto winOption = null;
        double temp = 0.0;
        for (ActivityPrizeOptionDto dto : validOptions) {
            if (!(randomNumber <= (temp += Double.valueOf(dto.getRate()).doubleValue()))) continue;
            winOption = dto;
            break;
        }
        if (null == winOption) {
            return this.awardCoupon(activityId, activityType, options);
        }
        return winOption;
    }

    private ActivityPrizeOptionDto awardCoupon(Long activityId, String activityType, List<ActivityPrizeOptionDto> options) {
        ArrayList couponOptions = Lists.newArrayList();
        for (ActivityPrizeOptionDto option : options) {
            if (!option.getPrizeType().equals("coupon")) continue;
            couponOptions.add(option);
        }
        if (couponOptions.isEmpty()) {
            LogUtil.logTodayKan((String)("ActivityPrizeOptionDto couponOptions is emputy,options===>" + JSONObject.toJSONString(options)));
            return this.awardThanks(activityId, activityType);
        }
        Collections.shuffle(couponOptions);
        return (ActivityPrizeOptionDto)couponOptions.get(0);
    }

    private ActivityPrizeOptionDto awardThanks(Long activityId, String activityType) {
        ActivityPrizeOptionDto option = new ActivityPrizeOptionDto();
        option.setActivityId(activityId);
        option.setActivityType(activityType);
        option.setPrizeType(ActivityPrizeOptionDto.Prize_Type_Thanks);
        option.setPrizeName("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        return option;
    }

    @Override
    public void creditsCallback(CreditsCallbackMessage message) {
        if (null == message || StringUtils.isBlank((CharSequence)message.getRelationId())) {
            return;
        }
        DubboResult orderResult = this.remoteActivityOrderService.findByOrderNum(message.getRelationId());
        if (!orderResult.isSuccess() || orderResult.getResult() == null) {
            return;
        }
        ActivityOrderDto order = (ActivityOrderDto)orderResult.getResult();
        if (order.getConsumeCreditsStatus() != 1) {
            return;
        }
        if ("completed".equals(message.getCallbackType())) {
            this.consumerCreditsCallback.completed(message);
        } else if ("failed".equals(message.getCallbackType())) {
            this.consumerCreditsCallback.failed(message);
        } else if ("cancelled".equals(message.getCallbackType())) {
            this.consumerCreditsCallback.cancelled(message);
        }
    }
}

