/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.exception.DeveloperConsumeFailedException;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerPluginService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.plugin.PluginFlowInnerService;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.common.util.LogUtil;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumerPluginServiceImpl
implements ConsumerPluginService {
    private static Logger log = LoggerFactory.getLogger(ConsumerPluginServiceImpl.class);
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private PluginFlowInnerService pluginFlowInnerService;

    @Override
    public void asyncConsumerPlug(Long consumerId, String orderNum, String transfer, String ip, String ua, String os, ActivityPluginDto pluDto) {
        DubboResult order = this.remoteActivityOrderService.findByOrderNum(orderNum);
        if (!order.isSuccess() || order.getResult() == null) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            this.onCreditsFail(message, new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd"));
            return;
        }
        CreditsCallbackMessage message = new CreditsCallbackMessage();
        message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
        message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
        message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
        HashMap params = Maps.newHashMap();
        params.put("ip", ip);
        message.setParams((Map)params);
        this.onCreditsSuccess(message, ua, os, pluDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreditsFail(CreditsCallbackMessage message, Exception exception) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        try {
            ActivityOrderDto o4u = new ActivityOrderDto();
            if (exception instanceof DeveloperConsumeFailedException && ((DeveloperConsumeFailedException)exception).getNormalFail().booleanValue()) {
                o4u.setError4admin("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + exception.getMessage());
                o4u.setError4developer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                o4u.setError4consumer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            } else {
                o4u.setError4admin("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + exception.getMessage());
                o4u.setError4developer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + exception.getMessage());
                o4u.setError4consumer("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            this.remoteActivityOrderService.consumeCreditsFail(order.getOrderNum(), null, null, null, null, null, null, null, null, null, o4u.getError4admin(), o4u.getError4developer(), o4u.getError4consumer());
            if (order.getConsumeCredits() > 0L) {
                this.remoteConsumerService.increaseCredits(order.getConsumerId(), order.getConsumeCredits());
            }
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd:", (Throwable)e);
        }
        finally {
            this.complete(order.getOrderNum());
            DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, exception));
        }
    }

    private void complete(String orderNum) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        if (order.getConsumeCreditsStatus() == 2) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == 3) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail, order));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCreditsSuccess(CreditsCallbackMessage message, String ua, String os, ActivityPluginDto pluDto) {
        String ip = (String)message.getParams().get("ip");
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        List<Object> options = Lists.newArrayList();
        if (order.getActivityType().equals("plugin")) {
            options = this.activityPrizeOptionService.queryActivityOptionsByConfigId(order.getDuibaActivityId(), ActivityPrizeOptionDto.Activity_Type_Plugin);
        }
        ActivityPrizeOptionDto winOption = this.pluginFlowInnerService.randomPrize(order.getDuibaActivityId(), order.getActivityType(), options);
        try {
            winOption = this.pluginFlowInnerService.winOptionCheck(order, winOption, options);
            this.pluginFlowInnerService.doWinPrize(order, winOption, options, ip, ua, os, pluDto);
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd:\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            LogUtil.logTodayKan((String)("ConsumerPluginServiceImpl onCreditsSuccess \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd winOption===>" + JSONObject.toJSONString((Object)winOption)));
            try {
                ActivityPrizeOptionDto option = this.pluginFlowInnerService.awardOptionLuck(order.getDuibaActivityId(), order.getActivityType(), options);
                winOption = this.pluginFlowInnerService.winOptionCheck(order, option, options);
                this.pluginFlowInnerService.doWinPrize(order, winOption, options, ip, ua, os, pluDto);
            }
            catch (Exception e1) {
                log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd:", (Throwable)e1);
                try {
                    ActivityPrizeOptionDto option = this.pluginFlowInnerService.awardThanks(order.getDuibaActivityId(), order.getActivityType());
                    this.pluginFlowInnerService.doWinPrize(order, option, options, ip, ua, os, pluDto);
                }
                catch (Exception e3) {
                    log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd: \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ", (Throwable)e3);
                }
            }
        }
        finally {
            this.complete(order.getOrderNum());
            ActivityOrderDto orderNew = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
            DuibaEventsDispatcher.get().dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(orderNew));
        }
    }
}

