/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.stock;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.service.GoodsService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityCouponStockPluginImpl
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ActivityCouponStockPluginImpl.class);
    @Autowired
    private RemoteItemKeyService remoteItemKeySerivce;
    @Autowired
    private GoodsService goodsService;
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){
        private static final String ACTIVITY_COUPON = "__activity_coupon_stock_consume";

        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSyncEvent.ActivityOrderPluginContext context) throws Exception {
            if (option.getPrizeType().equals("coupon")) {
                try {
                    ItemKey key = ActivityCouponStockPluginImpl.this.remoteItemKeySerivce.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                    CouponDO coupon = ActivityCouponStockPluginImpl.this.goodsService.getOneCoupon(key, order.getConsumerId(), order.getOrderNum());
                    if (null == coupon) {
                        throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                    }
                    context.setAttribute(ACTIVITY_COUPON, true);
                    context.setAttribute("couponId", coupon.getId());
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: getOneCoupon,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSyncEvent.ActivityOrderPluginContext context) {
            if (option.getPrizeType().equals("coupon")) {
                try {
                    Boolean hasadd = (Boolean)context.getAttribute(ACTIVITY_COUPON);
                    Object couponId = context.getAttribute("couponId");
                    if (hasadd != null && hasadd.booleanValue() && couponId != null) {
                        ItemKey key = ActivityCouponStockPluginImpl.this.remoteItemKeySerivce.getItemKey(option.getItemId(), option.getAppItemId(), order.getAppId());
                        ActivityCouponStockPluginImpl.this.goodsService.returnOneCoupon((Long)couponId, key, order.getOrderNum());
                    }
                    context.remove(ACTIVITY_COUPON);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: getOneCoupon,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
                }
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(this.orderPlugin);
    }
}

