/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.stock;

import cn.com.duiba.activity.center.api.dto.chaos.ActPreStockDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsRegister;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.stock.service.api.constant.ConsumeStockTypes;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivityOptionsStockPluginImpl
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(ActivityOptionsStockPluginImpl.class);
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    private ActivityOrderSyncEvent orderPlugin = new ActivityOrderSyncEvent(){
        private static final String ACTIVITY_CONSUME_STOCK = "__activity_ward_stock_consume";

        @Override
        public void afterOrderCreate(ActivityOrderDto order) {
        }

        @Override
        public void beforeStockComplete(ActivityOrderDto order, ActivityPrizeOptionDto option, ActivityOrderSyncEvent.ActivityOrderPluginContext context) throws Exception {
            if (option.getPrizeType().equals("object") || option.getPrizeType().equals("coupon")) {
                try {
                    if ("elasticGifts".equals(order.getActivityType())) {
                        return;
                    }
                    ArrayList stockIds = Lists.newArrayList();
                    ActPreStockDto preStock = ActivityOptionsStockPluginImpl.this.actPreStockSerivce.findPreStockByApp(option.getId(), ActivityPrizeOptionDto.Activity_Type_Rob, order.getAppId());
                    if (null != preStock) {
                        stockIds.add(preStock.getPrizeQuantity());
                    } else {
                        stockIds.add(option.getStockId());
                    }
                    DubboResult con = ActivityOptionsStockPluginImpl.this.remoteStockService.consumeStock(ConsumeStockTypes.ActivityOrder.getType(), order.getOrderNum(), (List)stockIds);
                    if (!con.isSuccess() || con.getResult() == null || !((Boolean)con.getResult()).booleanValue()) {
                        throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                    }
                    context.setAttribute(ACTIVITY_CONSUME_STOCK, true);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: consumnActivityOptionStock,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
                    throw e;
                }
            }
        }

        @Override
        public void beforeStockCompleteException(ActivityOrderDto order, ActivityPrizeOptionDto option, Exception exception, ActivityOrderSyncEvent.ActivityOrderPluginContext context) {
            if (option.getPrizeType().equals("object") || option.getPrizeType().equals("coupon")) {
                try {
                    DubboResult con;
                    if ("elasticGifts".equals(order.getActivityType())) {
                        return;
                    }
                    Boolean hasadd = (Boolean)context.getAttribute(ACTIVITY_CONSUME_STOCK);
                    if (!(hasadd == null || !hasadd.booleanValue() || (con = ActivityOptionsStockPluginImpl.this.remoteStockService.rollbackStock(ConsumeStockTypes.ActivityOrder.getType(), order.getOrderNum())).isSuccess() && con.getResult() != null && ((Boolean)con.getResult()).booleanValue())) {
                        throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                    }
                    context.remove(ACTIVITY_CONSUME_STOCK);
                }
                catch (Exception e) {
                    log.error("className: " + this.getClass().getName() + " method: paybackActivityOptionStock,\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
                }
            }
        }
    };

    public void afterPropertiesSet() throws Exception {
        DuibaEventsRegister.get().addActivityOrdersPlugin(this.orderPlugin);
    }
}

