/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl;

import cn.com.duiba.activity.center.api.dto.ActivityCategoryDto;
import cn.com.duiba.activity.center.api.dto.CategoryActivityDto;
import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.dto.other.ActivityCategorySpecifyDto;
import cn.com.duiba.activity.center.api.remoteservice.RemoteActivityCategoryBackendService;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryEntity;
import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;
import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryRelationService;
import cn.com.duiba.activity.center.biz.service.ActivityCategoryService;
import cn.com.duiba.activity.center.biz.service.chaos.ActivityCategorySpecifyService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteActivityCategoryBackendService")
public class RemoteActivityCategoryBackendServiceImpl
implements RemoteActivityCategoryBackendService {
    private static final Logger log = LoggerFactory.getLogger(RemoteActivityCategoryBackendServiceImpl.class);
    @Autowired
    private ActivityCategoryService activityCategoryService;
    @Autowired
    private ActivityCategoryRelationService activityCategoryRelationService;
    @Autowired
    private ActivityCategorySpecifyService activityCategorySpecifyService;

    public DubboResult<Long> createCategory(String name, String content) {
        try {
            Long id = this.activityCategoryService.createCategory(name, content);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            log.error("createCategory name=" + name, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> editCategoryContent(long id, String name, String content) {
        try {
            Boolean ret = this.activityCategoryService.editCategoryContent(id, name, content);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("editCategoryContent id=" + id + ",content=" + content, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> enableCategory(long id) {
        try {
            Boolean ret = this.activityCategoryService.enableCategory(id);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("enableCategory id=" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> disableCategory(long id) {
        try {
            Boolean ret = this.activityCategoryService.disableCategory(id);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("disableCategory id=" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ActivityCategoryDto>> findAll() {
        try {
            ArrayList<ActivityCategoryDto> ret = new ArrayList<ActivityCategoryDto>();
            List<ActivityCategoryEntity> list = this.activityCategoryService.findAll();
            for (ActivityCategoryEntity e : list) {
                ActivityCategoryDto dto = new ActivityCategoryDto();
                dto.setId(e.getId());
                dto.setName(e.getName());
                dto.setEnable(e.getEnable());
                dto.setContent(e.getContent());
                dto.setSpecify(e.getSpecify());
                ret.add(dto);
            }
            return DubboResult.successResult(ret);
        }
        catch (Exception e) {
            log.error("findAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteCategory(long id) {
        try {
            Boolean ret = this.activityCategoryService.deleteCategory(id);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("deleteCategory id=" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ActivityCategoryDto> findDefaultCategory() {
        try {
            ActivityCategoryEntity e = this.activityCategoryService.findDefaultCategory();
            if (e == null) {
                return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            ActivityCategoryDto dto = new ActivityCategoryDto();
            dto.setId(e.getId());
            dto.setName(e.getName());
            dto.setEnable(e.getEnable());
            dto.setContent(e.getContent());
            dto.setSpecify(e.getSpecify());
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findDefaultCategory", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CategoryActivityDto>> findAllActivitiesByAppCategory(long appId, long categoryId) {
        try {
            List<ActivityCategoryRelationEntity> acrs = this.activityCategoryRelationService.findByAppCategory(appId, categoryId);
            ArrayList<CategoryActivityDto> dtos = new ArrayList<CategoryActivityDto>();
            if (acrs != null && acrs.size() > 0) {
                for (ActivityCategoryRelationEntity acr : acrs) {
                    CategoryActivityDto dto = new CategoryActivityDto();
                    dto.setId(acr.getId());
                    dto.setOperatingId(acr.getOperatingActivityId());
                    dto.setPayload(acr.getPayload());
                    dto.setAppId(Long.valueOf(appId));
                    dto.setCategoryId(Long.valueOf(categoryId));
                    dtos.add(dto);
                }
            }
            return DubboResult.successResult(dtos);
        }
        catch (Exception e) {
            log.error("findAllActivitiesByAppCategory error,appId=" + appId + ",categoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sortActivitiesByAppCategory(long appId, long categoryId, List<CategoryActivityDto> activities) {
        try {
            if (this.activityCategoryRelationService.sortActivities(activities)) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        catch (Exception e) {
            log.error("sortActivitiesByAppCategory error,appId=" + appId + ",categoryId=" + categoryId + ",activities is list", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> saveActivityCategoryRelation(CategoryActivityDto dto) {
        Long appId = dto.getAppId();
        Long categoryId = dto.getCategoryId();
        Long oaId = dto.getOperatingId();
        Integer payload = dto.getPayload();
        if (appId == null) {
            return DubboResult.failResult((String)"appId \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (categoryId == null) {
            return DubboResult.failResult((String)"categoryId \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (oaId == null) {
            return DubboResult.failResult((String)"operatingActivityId \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (payload == null) {
            return DubboResult.failResult((String)"payload \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        ActivityCategoryRelationEntity entity = new ActivityCategoryRelationEntity();
        try {
            entity.setAppId(appId);
            entity.setCategoryId(categoryId);
            entity.setOperatingActivityId(oaId);
            entity.setPayload(payload);
            if (this.activityCategoryRelationService.save(entity)) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)("saveActivityCategoryRelation error,appId=" + appId + ",categoryId=" + categoryId + ",operatingActivityId=" + oaId + ",payload" + payload));
        }
        catch (Exception e) {
            log.error("saveActivityCategoryRelation error,appId=" + appId + ",categoryId=" + categoryId + ",operatingActivityId=" + oaId + ",payload" + payload, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> removeActivityCategoryRelation(Long operatingActivityId) {
        if (operatingActivityId == null) {
            return DubboResult.failResult((String)"operatingActivityId \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        try {
            if (this.activityCategoryRelationService.remove(operatingActivityId)) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        catch (Exception e) {
            log.error("error:", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<CategoryActivityDto> findActivityCategoryRelation(Long operatingActivityId) {
        try {
            CategoryActivityDto dto;
            ActivityCategoryRelationEntity rs = this.activityCategoryRelationService.findByOperatingActivityId(operatingActivityId);
            if (rs == null) {
                dto = null;
            } else {
                dto = new CategoryActivityDto();
                dto.setId(rs.getId());
                dto.setAppId(rs.getAppId());
                dto.setCategoryId(rs.getCategoryId());
                dto.setOperatingId(rs.getOperatingActivityId());
                dto.setPayload(rs.getPayload());
            }
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("findActivityCategoryRelation error,operatingActivityId=" + operatingActivityId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateActivityCategoryRelation(Long categoryId, List<OperatingActivityDto> operatingActivityList) {
        if (CollectionUtils.isEmpty(operatingActivityList)) {
            log.warn("operatingActivityIdList is null, categoryId=" + categoryId);
            return DubboResult.successResult((Object)true);
        }
        try {
            boolean rs = this.activityCategoryRelationService.updateActivityCategoryRelation(categoryId, operatingActivityList);
            if (rs) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdcategoryId=" + categoryId));
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdcategoryId=" + categoryId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ActivityCategorySpecifyDto>> findSpecifyAll(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
        try {
            ArrayList list = new ArrayList();
            List<ActivityCategorySpecifyEntity> ret = this.activityCategorySpecifyService.findAll(activityCategoryId, pageIndex, pageSize);
            ObjectUtil.convertList(ret, list, ActivityCategorySpecifyDto.class);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findSpecifyAll", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> findSpecifyAllCount(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
        try {
            return DubboResult.successResult((Object)this.activityCategorySpecifyService.findSpecifyAllCount(activityCategoryId, pageIndex, pageSize));
        }
        catch (Exception e) {
            log.error("findSpecifyAllCount", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> specifySave(ActivityCategorySpecifyDto activityCategorySpecifyDto) {
        try {
            ActivityCategorySpecifyEntity ac = new ActivityCategorySpecifyEntity();
            ObjectUtil.convert((Object)activityCategorySpecifyDto, (Object)ac);
            Boolean ret = this.activityCategorySpecifyService.specifySave(ac);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("specifySave", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> specifyDelete(Long id) {
        try {
            Boolean ret = this.activityCategorySpecifyService.specifyDelete(id);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("specifyDelete", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ActivityCategorySpecifyDto>> findByAppSpecifys(long appId) {
        try {
            ArrayList list = new ArrayList();
            List<ActivityCategorySpecifyEntity> ret = this.activityCategorySpecifyService.findByAppSpecifys(appId);
            ObjectUtil.convertList(ret, list, ActivityCategorySpecifyDto.class);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            log.error("findByAppSpecifys", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<ActivityCategoryDto>> findCategoryByAppId(Long appId) {
        try {
            List<ActivityCategoryEntity> list = this.activityCategoryService.findCategoryByAppId(appId);
            return DubboResult.successResult((Object)BeanUtils.copyList(list, ActivityCategoryDto.class));
        }
        catch (Exception e) {
            log.error("invoke findCategoryByAppId failed, appId=" + appId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

