/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.advert;

import cn.com.duiba.activity.center.api.dto.advertising.AdActivityDto;
import cn.com.duiba.activity.center.api.remoteservice.advertising.RemoteAdActivityService;
import cn.com.duiba.activity.center.biz.bo.activity.ActivityBo;
import cn.com.duiba.activity.center.biz.constant.DomainConfigureConstant;
import cn.com.duiba.activity.center.biz.entity.advert.DuibaAdMaterialEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.advert.DuibaAdMaterialService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.dubbo.DubboResult;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteAdActivityServiceImpl
implements RemoteAdActivityService {
    @Resource
    private DuibaAdMaterialService duibaAdMaterialService;
    @Resource
    private DuibaHdtoolService duibaHdtoolService;
    @Resource
    private OperatingActivityService operatingActivityService;
    @Resource
    private ActivityBo activityBo;
    @Resource
    private RemoteAppService remoteAppService;
    @Resource
    private CacheClient cacheClient;
    private static final Logger log = LoggerFactory.getLogger(RemoteAdActivityServiceImpl.class);

    public DubboResult<AdActivityDto> queryByActivityId(Long activityId, Integer activityType) {
        try {
            AdActivityDto rs = (AdActivityDto)this.cacheClient.get(this.keyGenerator(activityId, activityType));
            if (rs == null) {
                rs = new AdActivityDto();
                rs.setActivityId(activityId);
                rs.setActivityType(activityType);
                DuibaAdMaterialEntity m = this.duibaAdMaterialService.findByActivity(activityId, activityType);
                if (m != null) {
                    rs.setAdMaterialImg(m.getAdMaterialImg());
                    rs.setAdMaterialTitle(m.getAdMaterialTitle());
                    rs.setAdDescribe(m.getAdDescribe());
                } else {
                    rs = null;
                }
                this.cacheClient.set(this.keyGenerator(activityId, activityType), (Object)rs, 100);
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteAdActivityService.queryByActivityId(" + activityId + "," + activityType + ")", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AdActivityDto> addOnApp(Long activityId, Integer activityType, String appKey) {
        try {
            AdActivityDto dto = new AdActivityDto();
            dto.setActivityId(activityId);
            dto.setActivityType(activityType);
            AppDO app = this.remoteAppService.findByAppKey(appKey);
            if (app == null) {
                throw new Exception("appKey is not exist!");
            }
            Long operatingId = this.activityBo.addActivity(activityId, activityType, app.getId());
            dto.setOperatingActivityId(operatingId);
            String url = this.getUrl(activityType, operatingId, appKey);
            dto.setActivityUrl(url);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("RemoteAdActivityService.addOnApp() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    private String getUrl(Integer activityType, Long operatingId, String appKey) throws Exception {
        String url;
        if (6 == activityType) {
            url = this.getHdtoolUrl("shake", operatingId, appKey);
        } else if (7 == activityType) {
            url = this.getHdtoolUrl("ScratchCard", operatingId, appKey);
        } else if (9 == activityType) {
            url = this.getHdtoolUrl("tiger", operatingId, appKey);
        } else if (8 == activityType) {
            url = this.getHdtoolUrl("turntableNew", operatingId, appKey);
        } else if (11 == activityType) {
            url = this.getHdtoolUrl("flop", operatingId, appKey);
        } else if (12 == activityType) {
            url = this.getHdtoolUrl("smashg", operatingId, appKey);
        } else {
            throw new Exception("activityType not defined");
        }
        return url;
    }

    private String getHdtoolUrl(String action, Long operatingId, String appKey) {
        String url = DomainConfigureConstant.getAppDuibaCreditsDomainName() + "/activity/acShareIndex?url=/" + action + "/index/" + operatingId + "&apk=" + appKey;
        return url;
    }

    private String keyGenerator(Long activityId, Integer activityType) {
        return "advert-" + activityId + "-" + activityType + "-";
    }
}

