/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameDto;
import cn.com.duiba.activity.center.api.dto.creditgame.QueryParameters;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameBackendService;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameEntity;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityService;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteCreditGameBackendServiceImpl
implements RemoteCreditGameBackendService {
    @Resource
    private CreditGameService creditGameService;
    @Resource
    private OperatingActivityService operatingActivityService;
    private static Logger log = LoggerFactory.getLogger(RemoteCreditGameBackendServiceImpl.class);

    public DubboResult<Long> addCreditGame(CreditGameDto dto) {
        try {
            CreditGameEntity entity = new CreditGameEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            this.creditGameService.insert(entity);
            return DubboResult.successResult((Object)entity.getId());
        }
        catch (Exception e) {
            log.error("RemoteCreditGameBackendService.addCreditGame error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateCreditGame(Long id, CreditGameDto dto) {
        try {
            CreditGameEntity entity = new CreditGameEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            int i = this.creditGameService.update(entity);
            if (i == 1) {
                return DubboResult.successResult((Object)true);
            }
            return DubboResult.failResult((String)("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + i));
        }
        catch (Exception e) {
            log.error("RemoteCreditGameBackendService.updateCreditGame error,id=" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<CreditGameDto> getCreditGameByCreditGameId(Long id) {
        try {
            CreditGameEntity entity = this.creditGameService.getCreditGameById(id);
            CreditGameDto dto = new CreditGameDto();
            ObjectUtil.convert((Object)entity, (Object)dto);
            return DubboResult.successResult((Object)dto);
        }
        catch (Exception e) {
            log.error("RemoteCreditGameBackendService.getCreditGameByCreditGameId(" + id + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CreditGameDto>> getGamesByQueryParameters(QueryParameters queryParameters) {
        try {
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            log.error("RemoteCreditGameBackendService.getCreditGameByCreditGameId() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PaginationDto<CreditGameDto>> getCreditGamesByQueryAndPagingParameters(String title, PagingParameters pagingParameters) {
        try {
            PaginationDto rs = new PaginationDto();
            ArrayList dtos = Lists.newArrayList();
            Long total = this.creditGameService.findCount(title);
            if (total > 0L) {
                List<CreditGameEntity> entitys = this.creditGameService.findPage(title, pagingParameters.getOffset(), pagingParameters.getMax());
                if (CollectionUtils.isNotEmpty(entitys)) {
                    ObjectUtil.convertList(entitys, (List)dtos, CreditGameDto.class);
                } else {
                    log.error("creditGameService.findPage \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdcreditGameService.findCount \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + total);
                }
                rs.setRows((List)dtos);
                rs.setTotalCount(total);
            } else {
                rs.setRows((List)dtos);
                rs.setTotalCount(Long.valueOf(0L));
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteCreditGameBackendService.getCreditGamesByQueryAndPagingParameters() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteCreditGame(Long id) {
        try {
            this.creditGameService.delete(id);
            return DubboResult.successResult((Object)Boolean.TRUE);
        }
        catch (Exception e) {
            log.error("RemoteCreditGameBackendService.deleteCreditGame(" + id + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Integer> autoOff() {
        try {
            log.error("----\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd----");
            int ret = 0;
            List<Long> activityIds = this.creditGameService.findAutoOff();
            if (CollectionUtils.isNotEmpty(activityIds)) {
                for (Long activityId : activityIds) {
                    this.updateStatusCloseShow(activityId);
                    ++ret;
                }
            }
            log.error("----\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd----");
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("RemoteCreditGameBackendService.autoOff() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public void updateStatusCloseShow(Long activityId) {
        int ret = this.creditGameService.updateStatus(activityId, (byte)2);
        if (ret > 0) {
            try {
                this.operatingActivityService.updateStatusByActivityIdAndType(activityId, 46, 3);
            }
            catch (Exception e) {
                log.error("updateStatusCloseShow", (Throwable)e);
            }
        }
    }
}

