/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameDto;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameResultDto;
import cn.com.duiba.activity.center.api.dto.creditgame.GamePreResultDto;
import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameService;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameEntity;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RemoteCreditGameServiceImpl
implements RemoteCreditGameService {
    @Autowired
    private CreditGameService creditGameService;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private ConsumerCreditsService consumerCreditsService;
    @Autowired
    @Qualifier(value="notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    private static Logger log = LoggerFactory.getLogger(RemoteCreditGameServiceImpl.class);

    public DubboResult<GamePreResultDto> palyCreditGame(Long creditGameId, Long consumerId, String creditGameStepRecordId, Map<String, Object> creditGamesRuntimeParameters) {
        return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
    }

    public DubboResult<CreditGameResultDto> getPalyCreditGameResult(Long creditGameOrderId) {
        return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
    }

    public DubboResult<CreditGameDto> getCreditGameById(Long creditGameId) {
        try {
            Preconditions.checkNotNull((Object)creditGameId);
            CreditGameEntity creditGameEntity = (CreditGameEntity)this.creditGameService.queryById(creditGameId);
            CreditGameDto creditGameDto = new CreditGameDto();
            BeanUtils.copyProperties((Object)creditGameDto, (Object)creditGameEntity);
            return DubboResult.successResult((Object)creditGameDto);
        }
        catch (Throwable t) {
            return DubboResult.failResult((String)t.getMessage());
        }
    }

    public DubboResult<String> decrementCredit(CreditGameDto creditGame, Long consumerId, String orderNum, Long credits, String ipAddress, String transfer) {
        this.remoteConsumerService.decrementCredits(consumerId, credits);
        String description = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + creditGame.getCreditGameTitle();
        this.consumerCreditsService.asyncConsumerCredits(consumerId, orderNum, transfer, ipAddress, description);
        return null;
    }

    public DubboResult<String> incrementCredit(CreditGameDto creditGame, Long consumerId, String orderNum, Long credits, String ipAddress, String transfer) {
        return null;
    }

    public DubboResult<String> crementCreditNotify(String orderNum) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        this.insertHdtoolOrderNotifyQueueIfNesscery(order);
        if (order.getConsumeCreditsStatus() == 2) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == 3) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail, order));
        }
        return DubboResult.successResult((Object)order.getOrderNum());
    }

    private void insertHdtoolOrderNotifyQueueIfNesscery(ActivityOrderDto order) {
        try {
            if (order.getConsumeCredits() <= 0L) {
                return;
            }
            if (order.getConsumeCreditsStatus() == 1) {
                return;
            }
            ConsumerDO consumer = this.remoteConsumerService.find(order.getConsumerId());
            NotifyQueueDO nq = new NotifyQueueDO();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum("activity-" + order.getOrderNum());
            if (order.getError4developer() != null) {
                nq.setError4developer(order.getError4developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getDuibaActivityId());
            nq.setRelationType("rob");
            nq.setTimes(Integer.valueOf(0));
            nq.setResult(Boolean.valueOf(order.getConsumeCreditsStatus() == 2));
            this.notifyQueueDAO.insert(nq);
            this.notifyCenterServiceClient.notifyImmediately(nq.getId());
        }
        catch (Exception e) {
            log.error("insertHdtoolOrderNotifyQueueIfNesscery error", (Throwable)e);
        }
    }
}

