/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.elasticgifts;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermSimpleDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsTermTypeEnum;
import cn.com.duiba.activity.center.api.remoteservice.elasticgifts.RemoteElasticGiftsTermBackendService;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsTermService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="remoteElasticGiftsTermBackendService")
public class RemoteElasticGiftsTermBackendServiceImpl
implements RemoteElasticGiftsTermBackendService {
    private static Logger LOGGER = LoggerFactory.getLogger(RemoteElasticGiftsTermBackendServiceImpl.class);
    @Autowired
    private ElasticGiftsTermService elasticGiftsTermService;

    public DubboResult<List<ElasticGiftsTermSimpleDto>> getTermsByElasticGiftsId(Long elasticGiftsId) {
        try {
            List<ElasticGiftsTermSimpleDto> result = this.elasticGiftsTermService.getTermsByElasticGiftsId(elasticGiftsId);
            return DubboResult.successResult(result);
        }
        catch (Exception e) {
            LOGGER.error("getTermsByElasticGiftsId error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> sortTerms(List<Long> ids) {
        try {
            Boolean result = this.elasticGiftsTermService.sortTerms(ids);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("sortTerms error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delete(Long id) {
        try {
            Boolean result = this.elasticGiftsTermService.delete(id);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("delete error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> save(Long id, ElasticGiftsTermTypeEnum typeEnum, Long termId, Long elasticGiftsId, String title, String subtitle, String payIntro, String btnText) {
        try {
            Boolean result = this.elasticGiftsTermService.save(id, typeEnum, termId, elasticGiftsId, title, subtitle, payIntro, btnText);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("save error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<ElasticGiftsTermDto> getTermById(Long id) {
        try {
            ElasticGiftsTermDto result = this.elasticGiftsTermService.getTermById(id);
            return DubboResult.successResult((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("getTermById error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

