/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.littleGame;

import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.remoteservice.littlegame.RemoteLittleGameService;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.activity.center.biz.tools.service.ActualPriceCalService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.activity.center.biz.utils.MemLock;
import cn.com.duiba.dcommons.flowwork.ActivityLotteryFlowworkService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class RemoteLittleGameServiceImpl
implements RemoteLittleGameService {
    private static Logger log = LoggerFactory.getLogger(RemoteLittleGameServiceImpl.class);
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConsumerCreditsCallback consumerCreditsCallback;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private TimeLimitService timeLimitService;
    @Autowired
    private ItemKeyStockServcie itemKeyStockServcie;
    @Autowired
    private RemoteAddrLimitService remoteAddrLimitService;
    @Autowired
    private ActualPriceCalService actualPriceCalService;
    @Autowired
    private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired
    @Qualifier(value="notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    @Autowired
    private ActivityLotteryFlowworkService activityLotteryFlowworkService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;

    public DubboResult<String> haveGift(Long littleGameId, String orderNum, ActivityPrizeOptionDto winOption, String ip) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        try {
            this.doWinPrize(order, winOption, ip);
            return DubboResult.successResult((Object)orderNum);
        }
        catch (Exception e) {
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd====\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdID===" + winOption.getId() + "================\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd" + orderNum);
            return DubboResult.failResult((String)((StatusException)e).getMessage());
        }
    }

    public void doWinPrize(ActivityOrderDto order, ActivityPrizeOptionDto winOption, String ip) throws Exception {
        Long couponId = null;
        ActivityOrderSyncEvent.ActivityOrderPluginContext context = new ActivityOrderSyncEvent.ActivityOrderPluginContext();
        MemLock lock = new MemLock();
        lock.setLocked(false);
        try {
            if (winOption.getId() != null) {
                lock = this.frequentExchangeLimit.lockPrize(order.getDuibaActivityId(), order.getActivityType(), winOption.getId());
                if (lock.isLocked()) {
                    DuibaEventsDispatcher.get().triggerBeforeActivityOrderComplete(order, winOption, context);
                    Object obj = context.getAttribute("couponId");
                    if (null != obj) {
                        couponId = (Long)obj;
                    }
                } else {
                    throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                }
            }
            this.remoteActivityOrderService.consumeCreditsSuccess(order.getOrderNum(), winOption.getId(), winOption.getPrizeName(), winOption.getPrizeType(), winOption.getFacePrice(), winOption.getAppItemId(), winOption.getItemId(), winOption.getgId(), winOption.getgType(), couponId);
        }
        catch (Exception e) {
            if (lock.isLocked()) {
                DuibaEventsDispatcher.get().triggerOnActivityOrderCompleteException(order, winOption, e, context);
            }
            log.error("className: " + this.getClass().getName() + " method: doWinPrize", (Throwable)e);
            throw e;
        }
        finally {
            if (lock.isLocked()) {
                this.frequentExchangeLimit.unlockPrize(order.getDuibaActivityId(), order.getActivityType(), winOption.getId());
            }
        }
        if (!winOption.getPrizeType().equals(ActivityPrizeOptionDto.Prize_Type_Thanks)) {
            this.activityLotteryFlowworkService.insertCosumerExchanageRecord(order.getConsumerId(), order.getOrderNum(), order.getActivityType(), winOption.getPrizeType());
        }
        if (winOption.getPrizeType().equals("coupon")) {
            try {
                this.activityLotteryFlowworkService.autoTakePrize(order.getOrderNum(), order.getConsumerId(), order.getAppId(), ip, null);
            }
            catch (Exception e) {
                log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd================\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            }
        }
    }
}

