/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.rob.category;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobActivityDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryDetailDto;
import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.category.RemoteRobCategoryService;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RemoteRobCategoryServiceImpl
implements RemoteRobCategoryService {
    @Autowired
    private RobCategoryService robCategoryService;

    public DubboResult<List<RobCategoryDto>> getAllCategory() {
        List<RobCategoryEntity> robCategoryEntityList = this.robCategoryService.getAllCategory();
        return DubboResult.successResult(this.robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    public DubboResult<List<RobCategoryDto>> getByAppId(Long appId) {
        List<RobCategoryEntity> robCategoryEntityList = this.robCategoryService.getByAppId(appId);
        return DubboResult.successResult(this.robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    public DubboResult<List<TodayRobConfigDto>> getByCategoryId(Long categoryId, int offset, int pageSize) {
        return DubboResult.successResult(this.robCategoryService.getByCategoryId(categoryId, offset, pageSize));
    }

    public DubboResult<List<RobActivityDto>> getForManageByCategoryId(Long categoryId) {
        return DubboResult.successResult(this.robCategoryService.getForManageByCategoryId(categoryId));
    }

    public DubboResult<List<RobCategoryDto>> getCategoryByCategoryIds(final List<Long> categoryIdList) {
        List<RobCategoryEntity> robCategoryEntityList = this.robCategoryService.getRobCategorysByIds(categoryIdList);
        if (CollectionUtils.isEmpty(robCategoryEntityList)) {
            return DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        Collections.sort(robCategoryEntityList, new Comparator<RobCategoryEntity>(){

            @Override
            public int compare(RobCategoryEntity o1, RobCategoryEntity o2) {
                if (categoryIdList.indexOf(o1.getId()) > categoryIdList.indexOf(o2.getId())) {
                    return 1;
                }
                if (categoryIdList.indexOf(o1.getId()) < categoryIdList.indexOf(o2.getId())) {
                    return -1;
                }
                return 0;
            }
        });
        return DubboResult.successResult(this.robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    public DubboResult<List<RobCategoryDto>> getCategoryPage(String name, String title, Integer offset, Integer pageSize) {
        List<RobCategoryEntity> robCategoryEntityList = this.robCategoryService.getCategoryPage(name, title, offset, pageSize);
        return DubboResult.successResult(this.robCategoryEntityListToDtoList(robCategoryEntityList));
    }

    public DubboResult<Integer> countByNameAndTitle(String name, String title) {
        return DubboResult.successResult((Object)this.robCategoryService.countByNameAndTitle(name, title));
    }

    public DubboResult<Boolean> deleteById(Long id) {
        return DubboResult.successResult((Object)this.robCategoryService.deleteById(id));
    }

    public DubboResult<Boolean> insertCategory(RobCategoryDetailDto robCategoryDetailDto) {
        return DubboResult.successResult((Object)this.robCategoryService.insertCategory(robCategoryDetailDto));
    }

    public DubboResult<Boolean> batchDeleteCategoryActivityRelation(Long categoryId, List<Long> activityIds) {
        return DubboResult.successResult((Object)this.robCategoryService.batchDeleteCategoryActivityRelation(categoryId, activityIds));
    }

    public DubboResult<Boolean> batchUpdateRobCategoryActivityRelationPayload(RobCategoryDetailDto robCategoryDetailDto) {
        Map activitIdAndPayloadMap;
        Long categoryId = robCategoryDetailDto.getCategoryId();
        if (categoryId == null) {
            DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdid\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (CollectionUtils.isEmpty((Map)(activitIdAndPayloadMap = robCategoryDetailDto.getActivitIdAndPayloadMap()))) {
            DubboResult.failResult((String)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        return DubboResult.successResult((Object)this.robCategoryService.batchUpdateRobCategoryActivityRelationPayload(robCategoryDetailDto));
    }

    private List<RobCategoryDto> robCategoryEntityListToDtoList(List<RobCategoryEntity> robCategoryEntityList) {
        ArrayList<RobCategoryDto> robCategoryDtoList = new ArrayList<RobCategoryDto>();
        if (CollectionUtils.isEmpty(robCategoryEntityList)) {
            return robCategoryDtoList;
        }
        for (RobCategoryEntity robCategoryEntity : robCategoryEntityList) {
            robCategoryDtoList.add(this.robCategoryEntityToDto(robCategoryEntity));
        }
        return robCategoryDtoList;
    }

    private RobCategoryDto robCategoryEntityToDto(RobCategoryEntity robCategoryEntity) {
        return new RobCategoryDto(robCategoryEntity.getId(), robCategoryEntity.getTitle(), robCategoryEntity.getName());
    }
}

