/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.advert;

import cn.com.duiba.activity.center.biz.dao.advert.DuibaAdMaterialDao;
import cn.com.duiba.activity.center.biz.entity.advert.DuibaAdMaterialEntity;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class DuibaAdMaterialService {
    @Resource
    private DuibaAdMaterialDao duibaAdMaterialDao;
    @Resource
    private CacheClient cacheClient;

    public DuibaAdMaterialEntity find(Long id) {
        return this.duibaAdMaterialDao.selectByPrimaryKey(id);
    }

    public List<DuibaAdMaterialEntity> findByIds(List<Long> ids) {
        return this.duibaAdMaterialDao.selectByIds(ids);
    }

    public Long add(DuibaAdMaterialEntity entity) {
        Date date = new Date();
        entity.setGmtCreate(date);
        entity.setGmtModified(date);
        this.duibaAdMaterialDao.insertSelective(entity);
        return entity.getId();
    }

    public boolean update(DuibaAdMaterialEntity entity) {
        boolean rs;
        if (entity.getId() == null) {
            rs = false;
        } else {
            this.removeKeyById(entity.getId());
            int num = this.duibaAdMaterialDao.updateByPrimaryKeySelective(entity);
            rs = num == 1;
        }
        return rs;
    }

    public boolean delete(Long id) {
        this.removeKeyById(id);
        int num = this.duibaAdMaterialDao.deleteByPrimaryKey(id);
        boolean rs = num == 1;
        return rs;
    }

    public DuibaAdMaterialEntity findByActivity(Long activityId, Integer activityType) {
        DuibaAdMaterialEntity entity = (DuibaAdMaterialEntity)this.cacheClient.get(this.keyGenerator(activityId, activityType));
        if (entity == null) {
            entity = this.duibaAdMaterialDao.selelctByActivity(activityId, activityType);
            this.cacheClient.set(this.keyGenerator(activityId, activityType), (Object)entity, 1000);
        }
        return entity;
    }

    private void removeKeyById(Long id) {
        DuibaAdMaterialEntity old = this.duibaAdMaterialDao.selectByPrimaryKey(id);
        if (old != null) {
            this.cacheClient.remove(this.keyGenerator(old.getActivityId(), old.getActivityType()));
        }
    }

    private String keyGenerator(Long activityId, Integer activityType) {
        return "adMaterial-activityId-" + activityType;
    }
}

