/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.chaos.impl;

import cn.com.duiba.activity.center.biz.dao.category.ActivityCategoryDao;
import cn.com.duiba.activity.center.biz.dao.category.ActivityCategorySpecifyDao;
import cn.com.duiba.activity.center.biz.entity.chaos.ActivityCategorySpecifyEntity;
import cn.com.duiba.activity.center.biz.service.chaos.ActivityCategorySpecifyService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityCategorySpecifyServiceImpl
implements ActivityCategorySpecifyService {
    @Autowired
    private ActivityCategorySpecifyDao activityCategorySpecifyDao;
    @Autowired
    private ActivityCategoryDao activityCategoryDao;
    @Autowired
    private CacheClient memcachedClient;

    @Override
    public List<ActivityCategorySpecifyEntity> findAll(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
        return this.activityCategorySpecifyDao.selectSpecifyAll(activityCategoryId, pageIndex, pageSize);
    }

    @Override
    public Integer findSpecifyAllCount(Long activityCategoryId, Integer pageIndex, Integer pageSize) {
        return this.activityCategorySpecifyDao.selectSpecifyAllCount(activityCategoryId, pageIndex, pageSize);
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean specifySave(ActivityCategorySpecifyEntity activityCategorySpecifyEntity) {
        this.activityCategorySpecifyDao.insertSpecify(activityCategorySpecifyEntity);
        this.activityCategoryDao.updateCategorySpecify(activityCategorySpecifyEntity.getActivityCategoryId(), 1);
        this.memcachedClient.remove(this.getCategoryKey(activityCategorySpecifyEntity.getActivityCategoryId()));
        return true;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean specifyDelete(Long id) {
        ActivityCategorySpecifyEntity ac = this.activityCategorySpecifyDao.selectById(id);
        this.activityCategorySpecifyDao.deleteSpecify(id);
        this.memcachedClient.remove(this.getCategoryKey(ac.getActivityCategoryId()));
        if (this.activityCategorySpecifyDao.selectSpecifyAllCount(ac.getActivityCategoryId(), 1, 20) <= 0) {
            this.activityCategoryDao.updateCategorySpecify(ac.getActivityCategoryId(), 0);
        }
        return true;
    }

    @Override
    public List<ActivityCategorySpecifyEntity> findByAppSpecifys(Long appId) {
        return this.activityCategorySpecifyDao.selectByAppSpecifys(appId);
    }

    @Override
    public List<Long> findAppIdList(Long activityCategoryId) {
        List<Long> appIdList = (List<Long>)this.memcachedClient.get(this.getCategoryKey(activityCategoryId));
        if (CollectionUtils.isEmpty((Collection)appIdList) && CollectionUtils.isNotEmpty(appIdList = this.activityCategorySpecifyDao.findAppIdList(activityCategoryId))) {
            this.memcachedClient.set(this.getCategoryKey(activityCategoryId), appIdList, 600);
        }
        return appIdList;
    }

    private String getCategoryKey(Long activityCategoryId) {
        return "MS_CATEGORY_SPECIFY_CACHE" + activityCategoryId;
    }
}

