/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.elasticgifts.impl;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsEditDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsListDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermSimpleDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticTakeOrderDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.RequestParamsDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.api.enums.DeletedEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsStatusEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsTermTypeEnum;
import cn.com.duiba.activity.center.api.tool.Page;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsAppDao;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsDao;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsTermDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsAppEntity;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsEntity;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsTermEntity;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrderSyncEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsService;
import cn.com.duiba.activity.center.biz.service.elasticgifts.impl.ElasticGiftsAppServiceImpl;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.utils.MemLock;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.dcommons.flowwork.ActivityLotteryFlowworkService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.item.remoteservice.RemoteCouponFlowService;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="elasticGiftsService")
public class ElasticGiftsServiceImpl
implements ElasticGiftsService {
    private static Logger LOGGER = LoggerFactory.getLogger(ElasticGiftsServiceImpl.class);
    @Autowired
    private ElasticGiftsDao elasticGiftsDao;
    @Autowired
    private RemoteItemKeyService remoteItemKeySerivce;
    @Autowired
    private ElasticGiftsAppDao elasticGiftsAppDao;
    @Autowired
    private ElasticGiftsTermDao elasticGiftsTermDao;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteCouponFlowService remoteCouponFlowService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private ActivityLotteryFlowworkService activityLotteryFlowworkService;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimitService;
    private ExecutorService executorService = new ThreadPoolExecutor(5, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());

    @Override
    public Page<ElasticGiftsListDto> findElasticGiftsPage(Integer currentPage, Integer pageSize, ElasticGiftsBizCodeEnum bizCode, Long elasticGiftsId, String title4admin) {
        Preconditions.checkNotNull((Object)bizCode, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        if (currentPage == null) {
            currentPage = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        int offset = (currentPage - 1) * pageSize;
        int max = pageSize;
        Page page = new Page(pageSize.intValue(), currentPage.intValue());
        List<ElasticGiftsEntity> entities = this.elasticGiftsDao.findPage(offset, max, bizCode.value(), elasticGiftsId, title4admin);
        Integer count = this.elasticGiftsDao.findPageCount(bizCode.value(), elasticGiftsId, title4admin);
        page.setList(this.convertPageListDto(entities));
        page.setTotalCount(count == null ? 0 : count);
        return page;
    }

    private List<ElasticGiftsListDto> convertPageListDto(List<ElasticGiftsEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        ArrayList<ElasticGiftsListDto> result = new ArrayList<ElasticGiftsListDto>();
        for (ElasticGiftsEntity it : entities) {
            ElasticGiftsListDto dto = new ElasticGiftsListDto();
            dto.setId(it.getId());
            dto.setTitle4admin(it.getTitle4admin());
            dto.setBizCode(ElasticGiftsBizCodeEnum.fromValue((int)it.getBizCode()));
            dto.setStatus(ElasticGiftsStatusEnum.fromValue((int)it.getStatus()));
            dto.setAppCount(Integer.valueOf(this.getAppCountByElId(it.getId())));
            dto.setTermCount(Integer.valueOf(this.getTermCountByElId(it.getId())));
            result.add(dto);
        }
        return result;
    }

    private int getAppCountByElId(Long elasticGiftsId) {
        List<Long> appIds = this.elasticGiftsAppDao.getAppIdsByElasticGiftsId(elasticGiftsId);
        return appIds.size();
    }

    private int getTermCountByElId(Long elasticGiftsId) {
        List<ElasticGiftsTermEntity> terms = this.elasticGiftsTermDao.findAllByElId(elasticGiftsId);
        return terms.size();
    }

    @Override
    public Boolean updateStatus(Long elasticGiftsId, ElasticGiftsStatusEnum targetStatus) {
        Preconditions.checkNotNull((Object)elasticGiftsId, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd id \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd null");
        Preconditions.checkNotNull((Object)targetStatus, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd null");
        return this.elasticGiftsDao.updateStatus(elasticGiftsId, targetStatus.value()) > 0;
    }

    @Override
    public List<Long> getAppIdsByElasticGiftsId(Long elasticGiftsId) {
        return this.elasticGiftsAppDao.getAppIdsByElasticGiftsId(elasticGiftsId);
    }

    @Override
    public Boolean delete(Long elasticGiftsId) {
        this.elasticGiftsTermDao.deleteByElId(elasticGiftsId);
        return this.elasticGiftsDao.delete(elasticGiftsId) > 0;
    }

    @Override
    public Boolean save(Long elasticGiftsId, String title4admin, ElasticGiftsBizCodeEnum bizCode, List<Long> termIds) {
        Preconditions.checkNotNull((Object)bizCode, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd null");
        Long elId = this.saveEl(elasticGiftsId, title4admin, bizCode);
        if (this.isCreateOrCpoy(elasticGiftsId) && CollectionUtils.isEmpty(termIds)) {
            return true;
        }
        List<ElasticGiftsTermEntity> terms = this.getSortedTerms(termIds);
        if (this.isCreateOrCpoy(elasticGiftsId)) {
            this.copyTerms(terms, elId);
            return true;
        }
        List<ElasticGiftsTermEntity> oldTerms = this.elasticGiftsTermDao.findAllByElId(elId);
        this.deleteTerms(oldTerms, terms);
        return true;
    }

    private boolean isCreateOrCpoy(Long elasticGiftsId) {
        return elasticGiftsId == null;
    }

    private void deleteTerms(List<ElasticGiftsTermEntity> oldTerms, List<ElasticGiftsTermEntity> terms) {
        if (CollectionUtils.isEmpty(oldTerms)) {
            return;
        }
        oldTerms.removeAll(terms);
        for (ElasticGiftsTermEntity it : oldTerms) {
            this.elasticGiftsTermDao.delete(it.getId());
        }
    }

    private List<ElasticGiftsTermEntity> getSortedTerms(final List<Long> termIds) {
        if (CollectionUtils.isEmpty(termIds)) {
            return Collections.emptyList();
        }
        List<ElasticGiftsTermEntity> terms = this.elasticGiftsTermDao.findAllByIds(termIds);
        Collections.sort(terms, new Comparator<ElasticGiftsTermEntity>(){

            @Override
            public int compare(ElasticGiftsTermEntity o1, ElasticGiftsTermEntity o2) {
                if (termIds.indexOf(o1.getId()) > termIds.indexOf(o2.getId())) {
                    return 1;
                }
                if (termIds.indexOf(o1.getId()) < termIds.indexOf(o2.getId())) {
                    return -1;
                }
                return 0;
            }
        });
        return terms;
    }

    private void copyTerms(List<ElasticGiftsTermEntity> terms, Long elasticGiftsId) {
        if (CollectionUtils.isEmpty(terms)) {
            return;
        }
        int payload = 1;
        for (ElasticGiftsTermEntity it : terms) {
            ElasticGiftsTermEntity e4i = new ElasticGiftsTermEntity();
            BeanUtils.copyProperties((Object)it, (Object)e4i, (String[])new String[]{"id"});
            e4i.setDeleted(DeletedEnum.UNDELETED.value());
            e4i.setElasticGiftsId(elasticGiftsId);
            e4i.setPayload(payload++);
            this.elasticGiftsTermDao.insert(e4i);
        }
    }

    private Long saveEl(Long elasticGiftsId, String title4admin, ElasticGiftsBizCodeEnum bizCode) {
        if (this.isCreateOrCpoy(elasticGiftsId)) {
            ElasticGiftsEntity e4i = new ElasticGiftsEntity();
            e4i.setTitle4admin(title4admin);
            e4i.setTitle(null);
            e4i.setStatus(ElasticGiftsStatusEnum.CLOSE_AND_UNVIEW.value());
            e4i.setBizCode(bizCode.value());
            e4i.setDeleted(DeletedEnum.UNDELETED.value());
            int ret = this.elasticGiftsDao.insert(e4i);
            if (ret <= 0) {
                throw new RuntimeException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            }
            return e4i.getId();
        }
        ElasticGiftsEntity e4u = new ElasticGiftsEntity();
        e4u.setId(elasticGiftsId);
        e4u.setTitle4admin(title4admin);
        int ret = this.elasticGiftsDao.update(e4u);
        if (ret <= 0) {
            throw new RuntimeException("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        return e4u.getId();
    }

    @Override
    public ElasticGiftsEditDto getElasticGiftsById(Long elasticGiftsId) {
        Preconditions.checkNotNull((Object)elasticGiftsId, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd id \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd null");
        ElasticGiftsEntity entity = this.elasticGiftsDao.find(elasticGiftsId);
        List<ElasticGiftsTermEntity> termEntities = this.elasticGiftsTermDao.findAllByElId(entity.getId());
        ArrayList<ElasticGiftsTermSimpleDto> terms = new ArrayList<ElasticGiftsTermSimpleDto>();
        for (ElasticGiftsTermEntity it : termEntities) {
            ElasticGiftsTermSimpleDto term = new ElasticGiftsTermSimpleDto(it.getId(), it.getTermId(), it.getPayload());
            terms.add(term);
        }
        ElasticGiftsEditDto dto = new ElasticGiftsEditDto();
        dto.setId(entity.getId());
        dto.setBizCode(ElasticGiftsBizCodeEnum.fromValue((int)entity.getBizCode()));
        dto.setTitle4admin(entity.getTitle4admin());
        dto.setTerms(terms);
        return dto;
    }

    @Override
    public List<ElasticGiftsDto> getElasticGiftsByText(ElasticGiftsBizCodeEnum bizCode, String text) {
        List<ElasticGiftsEntity> entities;
        Preconditions.checkNotNull((Object)bizCode, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd null");
        ElasticGiftsEntity entity4id = null;
        if (StringUtils.isNotBlank((CharSequence)text) && StringUtils.isNumeric((CharSequence)text)) {
            Long id = Long.valueOf(text);
            entity4id = this.elasticGiftsDao.findByIdAndBizCode(id, bizCode.value());
        }
        if (!(entities = this.elasticGiftsDao.findAllByTitle4adminAndBizCode(text, bizCode.value())).contains(entity4id)) {
            entities.add(entity4id);
        }
        return cn.com.duiba.wolf.utils.BeanUtils.copyList(entities, ElasticGiftsDto.class);
    }

    @Override
    public Tuple.Tuple2<ElasticGiftsDto, List<ElasticGiftsTermDto>> getElasticGiftsForMobile(ElasticGiftsBizCodeEnum bizCode, Long appId) throws Exception {
        Preconditions.checkNotNull((Object)appId, (Object)"appId\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdnull");
        Preconditions.checkNotNull((Object)bizCode, (Object)"bizCode\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdnull");
        Long elasticGiftsId = this.getElasticGiftsId(bizCode.value(), appId);
        if (elasticGiftsId == null) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd id \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        ElasticGiftsEntity gift = this.elasticGiftsDao.find(elasticGiftsId);
        if (gift == null || DeletedEnum.DELETED.value() == gift.getDeleted().intValue()) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (ElasticGiftsStatusEnum.OPEN.value() != gift.getStatus().intValue()) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        List<ElasticGiftsTermEntity> terms = this.elasticGiftsTermDao.findAllByElId(gift.getId());
        ArrayList<ElasticGiftsTermDto> dtos = new ArrayList<ElasticGiftsTermDto>(terms.size());
        for (ElasticGiftsTermEntity it : terms) {
            ElasticGiftsTermDto dto = new ElasticGiftsTermDto();
            BeanUtils.copyProperties((Object)it, (Object)dto, (String[])new String[]{"termType", "deleted"});
            dto.setDeleted(DeletedEnum.fromValue((int)it.getDeleted()));
            dto.setTermType(ElasticGiftsTermTypeEnum.fromValue((int)it.getTermType()));
            dtos.add(dto);
        }
        ElasticGiftsDto eldto = (ElasticGiftsDto)cn.com.duiba.wolf.utils.BeanUtils.copy((Object)gift, ElasticGiftsDto.class);
        return Tuple.tuple((Object)eldto, dtos);
    }

    private Long getElasticGiftsId(Integer bizCode, Long appId) throws Exception {
        ElasticGiftsAppEntity elApp = this.elasticGiftsAppDao.findByBizCodeAndAppId(bizCode, appId);
        if (elApp != null) {
            return elApp.getElasticGiftsId();
        }
        ElasticGiftsAppEntity commonApp = this.elasticGiftsAppDao.findByBizCodeAndAppId(bizCode, 0L);
        if (commonApp != null) {
            return commonApp.getElasticGiftsId();
        }
        throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
    }

    @Override
    public ElasticTakeOrderDto checkElasticTakeOrder(Long egTermId, Long appId) throws Exception {
        Preconditions.checkNotNull((Object)egTermId, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        Preconditions.checkNotNull((Object)appId, (Object)"appId \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        ElasticGiftsTermEntity term = this.elasticGiftsTermDao.find(egTermId);
        if (term == null || DeletedEnum.DELETED.value() == term.getDeleted().intValue()) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        ElasticGiftsEntity gift = this.elasticGiftsDao.find(term.getElasticGiftsId());
        if (gift == null || DeletedEnum.DELETED.value() == gift.getDeleted().intValue()) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        ElasticGiftsAppEntity giftsApp = this.elasticGiftsAppDao.findByBizCodeAndAppId(gift.getBizCode(), appId);
        if (giftsApp == null) {
            giftsApp = this.elasticGiftsAppDao.findByBizCodeAndAppId(gift.getBizCode(), ElasticGiftsAppServiceImpl.APP_COMMON_LIST.get(0));
        }
        if (!giftsApp.getElasticGiftsId().equals(gift.getId())) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        ElasticGiftsDto giftsDto = new ElasticGiftsDto();
        BeanUtils.copyProperties((Object)gift, (Object)giftsDto);
        return new ElasticTakeOrderDto(giftsDto, term.getId(), term.getTermId());
    }

    @Override
    public String takeOrder(ElasticGiftsDto dto, Long itemId, Long appId, Long consumerId, RequestParamsDto requestParamsDto) throws Exception {
        String orderNum;
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        ActivityOrderDto orderDto = new ActivityOrderDto();
        orderDto.setConsumerId(consumer.getId());
        orderDto.setAppId(consumer.getAppId());
        orderDto.setPartnerUserId(consumer.getPartnerUserId());
        orderDto.setDuibaActivityId(dto.getId());
        orderDto.setActivityType("elasticGifts");
        orderDto.setConsumeCredits(Long.valueOf(0L));
        orderDto.setExchangeStatus(Integer.valueOf(1));
        orderDto.setConsumeCreditsStatus(Integer.valueOf(1));
        orderDto.setIp(requestParamsDto.getIp());
        orderDto.setItemId(itemId);
        orderDto.setActivityOptionType("coupon");
        orderDto.setGid(itemId);
        orderDto.setGtype(GoodsTypeEnum.DUIBA.getGtype() + "");
        Date now = new Date();
        orderDto.setGmtCreate(now);
        orderDto.setGmtModified(now);
        try {
            orderNum = (String)this.remoteActivityOrderService.createOrder(orderDto).getResult();
            this.elasticGiftsFlowwork(orderNum);
        }
        catch (Exception e) {
            LOGGER.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            throw e;
        }
        return orderNum;
    }

    private void elasticGiftsFlowwork(final String orderNum) {
        Preconditions.checkNotNull((Object)orderNum, (Object)"\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                AtomicInteger ai = new AtomicInteger(5);
                try {
                    this.process(ai);
                }
                catch (Exception e) {
                    LOGGER.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd, orderNum = " + orderNum, (Throwable)e);
                }
            }

            private void process(AtomicInteger tryCount) throws Exception {
                ActivityOrderDto order = (ActivityOrderDto)ElasticGiftsServiceImpl.this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
                ActivityPrizeOptionDto option = new ActivityPrizeOptionDto();
                option.setItemId(order.getItemId());
                option.setActivityType(order.getActivityType());
                option.setPrizeType("coupon");
                ActivityOrderSyncEvent.ActivityOrderPluginContext context = new ActivityOrderSyncEvent.ActivityOrderPluginContext();
                MemLock lock = new MemLock();
                lock.setLocked(false);
                try {
                    lock = ElasticGiftsServiceImpl.this.frequentExchangeLimitService.lockPrize(order.getDuibaActivityId(), order.getActivityType(), order.getItemId());
                    Long couponId = null;
                    if (lock.isLocked()) {
                        DuibaEventsDispatcher.get().triggerBeforeActivityOrderComplete(order, option, context);
                        Object obj = context.getAttribute("couponId");
                        if (null != obj) {
                            couponId = (Long)obj;
                        }
                    } else {
                        if (tryCount.decrementAndGet() <= 0) {
                            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                        }
                        this.process(tryCount);
                    }
                    DubboResult result = ElasticGiftsServiceImpl.this.remoteActivityOrderService.consumeCreditsSuccess(orderNum, null, null, null, null, null, null, null, null, couponId);
                    if (!result.isSuccess() || result.getResult() == null || !((Boolean)result.getResult()).booleanValue()) {
                        throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd couponId\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
                    }
                }
                catch (Exception e) {
                    if (lock.isLocked()) {
                        DuibaEventsDispatcher.get().triggerOnActivityOrderCompleteException(order, option, e, context);
                    }
                    throw e;
                }
                finally {
                    if (lock.isLocked()) {
                        ElasticGiftsServiceImpl.this.frequentExchangeLimitService.unlockPrize(order.getDuibaActivityId(), order.getActivityType(), order.getItemId());
                    }
                }
                this.complete(order);
            }

            private void complete(ActivityOrderDto order) {
                ElasticGiftsServiceImpl.this.activityLotteryFlowworkService.insertCosumerExchanageRecord(order.getConsumerId(), order.getOrderNum(), order.getActivityType(), order.getActivityOptionType());
                ElasticGiftsServiceImpl.this.activityLotteryFlowworkService.autoTakePrize(orderNum, order.getConsumerId(), order.getAppId(), order.getIp(), null);
                if (order.getConsumeCreditsStatus() == 2) {
                    DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess, order));
                } else if (order.getConsumeCreditsStatus() == 3) {
                    DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail, order));
                }
            }
        });
    }
}

