/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.luckbag;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.api.dto.prize.ActivityPrizeOptionDto;
import cn.com.duiba.activity.center.biz.service.luckbag.LuckBagCallback;
import cn.com.duiba.activity.center.biz.service.luckbag.LuckBagRequest;
import cn.com.duiba.activity.center.biz.service.plugin.PluginFlowInnerService;
import cn.com.duiba.dcommons.flowwork.ActivityPluginFlowworkService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.service.IEngineService;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.List;
import net.rubyeye.xmemcached.MemcachedClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="luckBagFlowWorker")
public class LuckBagFlowWorkerImpl
implements LuckBagCallback.LuckBagFlowWorker {
    private static Logger log = LoggerFactory.getLogger(LuckBagFlowWorkerImpl.class);
    @Autowired
    private ActivityPluginFlowworkService activityPluginFlowworkService;
    private MemcachedClient memcachedClient;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    private IEngineService iEngineService;
    @Autowired
    private PluginFlowInnerService pluginFlowInnerService;

    @Override
    public void asyncHttpRequest(String orderId, Long consumerId, Long operatingAcitivityId, Long appId, String ip, String ua, String tag, String buttonType, String infoType, String info, String os, String userAgent, List<ActivityPrizeOptionDto> options, ActivityPluginDto pluDto) throws Exception {
        LuckBagRequest req = LuckBagRequest.buildRequestData(orderId, consumerId, operatingAcitivityId, appId, ip, ua, null, tag, os, options, pluDto);
        this.LuckBagRequestServer(req, new LuckBagCallBackResponse(orderId, consumerId, operatingAcitivityId, null, req), buttonType, infoType, info, os, userAgent);
    }

    private void LuckBagRequestServer(LuckBagRequest req, LuckBagCallback callback, String buttonType, String infoType, String info, String os, String userAgent) throws Exception {
        ObtainAdvertReq obtain = new ObtainAdvertReq();
        obtain.setConsumerId(req.getConsumerId());
        obtain.setUa(req.getUa());
        obtain.setOrderId(req.getOrderId());
        obtain.setIp(req.getIp());
        obtain.setAppId(req.getAppId());
        obtain.setActivityId(req.getOperatingActivityId());
        obtain.setTimestamp(Long.valueOf(new Date().getTime()));
        obtain.setTag(req.getTag());
        obtain.setLoginType("1");
        obtain.setButtonType(buttonType);
        obtain.setInfoType(infoType);
        obtain.setInfo(info);
        obtain.setOs(os);
        obtain.setType("2");
        obtain.setUserAgent(userAgent);
        ObtainAdvertRsp advert = null;
        try {
            advert = this.iEngineService.obtainAdvert(obtain);
            if (null == advert || !advert.isResult()) {
                callback.onException(new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd"));
                return;
            }
            callback.onFinish(advert);
        }
        catch (Exception e) {
            log.error("es submit obtain advert error", (Throwable)e);
            callback.onException(e);
        }
    }

    private class LuckBagCallBackResponse
    implements LuckBagCallback {
        private String orderId;
        private Long activityId;
        private LuckBagRequest req;

        public LuckBagCallBackResponse(String orderId, Long consumerId, Long activityId, Long orderExtraId, LuckBagRequest req) {
            this.orderId = orderId;
            this.activityId = activityId;
            this.req = req;
        }

        @Override
        public void onFinish(ObtainAdvertRsp advert) throws Exception {
            if (null == advert) {
                this.onException(new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd"));
                return;
            }
            ActivityOrderDto order = (ActivityOrderDto)LuckBagFlowWorkerImpl.this.remoteActivityOrderService.findByOrderNum(this.orderId).getResult();
            LuckBagFlowWorkerImpl.this.activityPluginFlowworkService.insertCosumerExchanageRecord(this.req.getConsumerId(), this.req.getOrderId(), "plugin", order.getActivityOptionType());
            LuckBagFlowWorkerImpl.this.memcachedClient.set(this.getMemKey(this.orderId), 10, (Object)JSONObject.toJSONString((Object)advert));
            LuckBagFlowWorkerImpl.this.remoteActivityOrderService.exchangeStatusToSuccess(this.orderId);
        }

        @Override
        public void onException(Exception ex) throws Exception {
            ActivityOrderDto order = (ActivityOrderDto)LuckBagFlowWorkerImpl.this.remoteActivityOrderService.findByOrderNum(this.orderId).getResult();
            ActivityPrizeOptionDto option = LuckBagFlowWorkerImpl.this.pluginFlowInnerService.awardThanks(this.activityId, order.getActivityType());
            LuckBagFlowWorkerImpl.this.pluginFlowInnerService.doWinPrize(order, option, this.req.getOptions(), this.req.getIp(), this.req.getUa(), this.req.getOs(), this.req.getPluDto());
        }

        private String getMemKey(String orderId) {
            return "MS_LUCK_BAG_CACHE-" + orderId;
        }
    }
}

