/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.seckill.impl;

import cn.com.duiba.activity.center.api.dto.seckill.SeckillStockDto;
import cn.com.duiba.activity.center.biz.dao.seckill.DuibaSeckillDao;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillEntity;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigEntity;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillDateUtilService;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillMemcacheService;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillService;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillStockService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="seckillService")
public class SeckillServiceImpl
implements SeckillService {
    private static Logger LOGGER = LoggerFactory.getLogger(SeckillServiceImpl.class);
    @Autowired
    private SeckillMemcacheService seckillMemcacheService;
    @Autowired
    private DuibaSeckillDao duibaSeckillDao;
    @Autowired
    private SeckillStockService seckillStockService;
    @Autowired
    private SeckillDateUtilService seckillDateUtilService;
    private static Cache<String, SeckillService.SeckillStockCache> stockCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).build();
    private static Cache<Long, DuibaSeckillEntity> seckillCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    private static String getStockCacheKey(Long appId, Long duibaSeckillId) {
        if (appId == null || duibaSeckillId == null) {
            return null;
        }
        return duibaSeckillId + "-" + appId;
    }

    @Override
    public Long getStock(Long appId, DuibaSeckillEntity duibaSeckill) {
        Long stockId = null;
        try {
            stockId = this.getStockId(appId, duibaSeckill);
        }
        catch (Exception e) {
            LOGGER.error("getStockId error\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd0\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            return 0L;
        }
        return this.getStockByMemchache(stockId, duibaSeckill, appId);
    }

    @Override
    public List<SeckillStockDto> batchGetStock(Long appId, List<Long> duibaSeckillIds) throws Exception {
        if (CollectionUtils.isEmpty(duibaSeckillIds)) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        if (appId == null) {
            throw new Exception("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        }
        ArrayList<SeckillStockDto> result = new ArrayList<SeckillStockDto>();
        for (final Long it : duibaSeckillIds) {
            DuibaSeckillEntity entity;
            if (it == null || (entity = (DuibaSeckillEntity)seckillCache.get((Object)it, (Callable)new Callable<DuibaSeckillEntity>(){

                @Override
                public DuibaSeckillEntity call() {
                    return SeckillServiceImpl.this.duibaSeckillDao.find(it);
                }
            })) == null) continue;
            Long stock = this.getStock(appId, entity);
            result.add(new SeckillStockDto(it, appId, stock));
        }
        return result;
    }

    private long getStockByMemchache(Long stockId, DuibaSeckillEntity duibaSeckill, Long appId) {
        if (!this.seckillDateUtilService.isNowBeforeAfter5Min(duibaSeckill, new Date())) {
            this.seckillMemcacheService.invalidateStockCacheById(stockId);
            DuibaSeckillStockConfigEntity stockConfig = this.seckillStockService.findStockByUnique(duibaSeckill.getId(), appId);
            return stockConfig.getStock().intValue();
        }
        return this.seckillMemcacheService.getMemcachedStockById(stockId, duibaSeckill.getId(), appId);
    }

    private Long getStockId(final Long appId, final DuibaSeckillEntity duibaSeckill) throws Exception {
        String key = SeckillServiceImpl.getStockCacheKey(appId, duibaSeckill.getId());
        if (!this.seckillDateUtilService.isNowBeforeAfter5Min(duibaSeckill, new Date())) {
            stockCache.invalidate((Object)key);
            DuibaSeckillStockConfigEntity stockConfig = this.seckillStockService.findStockByUnique(duibaSeckill.getId(), appId);
            return stockConfig.getId();
        }
        SeckillService.SeckillStockCache sCache = (SeckillService.SeckillStockCache)stockCache.get((Object)key, (Callable)new Callable<SeckillService.SeckillStockCache>(){

            @Override
            public SeckillService.SeckillStockCache call() throws Exception {
                DuibaSeckillStockConfigEntity stockConfig = SeckillServiceImpl.this.seckillStockService.findStockByUnique(duibaSeckill.getId(), appId);
                SeckillService.SeckillStockCache stockCache = new SeckillService.SeckillStockCache();
                stockCache.setId(stockConfig.getId());
                stockCache.setDuibaSeckillId(stockConfig.getSeckillId());
                stockCache.setAppId(appId);
                stockCache.setRemaining(stockConfig.getStock().longValue());
                return stockCache;
            }
        });
        return sCache.getId();
    }
}

