/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.tools.service;

import cn.com.duiba.activity.center.biz.tools.XMemCacheClient;
import cn.com.duiba.activity.center.common.util.DateUtil;
import net.rubyeye.xmemcached.GetsResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class TodayActivityStatisticsService {
    private static Logger log = LoggerFactory.getLogger(TodayActivityStatisticsService.class);
    private final String OPERATING_ACTIVITY = "activity_";
    @Autowired
    @Qualifier(value="memCacheClient")
    private XMemCacheClient xMemCacheClient;

    public void addTodayConsumeCredits(Long activityId, String activityType, Long appId, Long credits) {
        if (credits != null && activityId != null) {
            try {
                String creditsKey = "activity_" + activityId + "_" + activityType + "_" + appId + "_credits";
                if (this.setByCas(creditsKey, credits.intValue(), 1) == 2) {
                    this.xMemCacheClient.getMemcachedClient().set(creditsKey, DateUtil.getToTomorrowSeconds(), (Object)credits.intValue());
                }
            }
            catch (Exception e) {
                log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            }
        }
    }

    public void rollbackTodayConsumeCredits(Long activityid, String activityType, Long appId, Long credits) {
        if (credits != null && activityid != null) {
            try {
                String creditsKey = "activity_" + activityid + "_" + activityType + "_" + appId + "_credits";
                this.setByCas(creditsKey, credits.intValue(), -1);
            }
            catch (Exception e) {
                log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            }
        }
    }

    public void addTodayWinCount(Long ativityId, String activityType, Long appId) {
        if (ativityId != null) {
            try {
                String winCountKey = "activity_" + ativityId + "_" + activityType + "_" + appId + "_winCount";
                if (this.setByCas(winCountKey, 1, 1) == 2) {
                    this.xMemCacheClient.getMemcachedClient().add(winCountKey, DateUtil.getToTomorrowSeconds(), (Object)1);
                }
            }
            catch (Exception e) {
                log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd", (Throwable)e);
            }
        }
    }

    private Integer setByCas(String key, int value, int type) {
        Integer result = null;
        try {
            int loopNum = 0;
            while (true) {
                if (loopNum >= 10) {
                    result = 1;
                    break;
                }
                GetsResponse last = this.xMemCacheClient.getMemcachedClient().gets(key);
                if (last == null) {
                    result = 2;
                    break;
                }
                int nextValue = (Integer)last.getValue();
                if (type > 0) {
                    nextValue += value;
                } else if (type < 0) {
                    nextValue = nextValue >= value ? (nextValue -= value) : 0;
                } else {
                    result = 4;
                    break;
                }
                boolean bo = this.xMemCacheClient.getMemcachedClient().cas(key, DateUtil.getToTomorrowSeconds(), (Object)nextValue, last.getCas());
                if (bo) {
                    result = 0;
                    break;
                }
                ++loopNum;
            }
        }
        catch (Exception e) {
            result = 5;
            log.error("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd:", (Throwable)e);
        }
        return result;
    }
}

