/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.bo;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.DuibaHdtoolOptionsDto;
import cn.com.duiba.activity.center.api.dto.hdtool.HdtoolStockConsumeDto;
import cn.com.duiba.activity.center.biz.service.activity.OperatingActivityOptionsService;
import cn.com.duiba.activity.center.biz.service.hdtool.DuibaHdtoolOptionsService;
import cn.com.duiba.activity.center.biz.service.hdtool.HdtoolStockConsumeService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HdtoolStockConsumeBo {
    private static Logger log = LoggerFactory.getLogger(HdtoolStockConsumeBo.class);
    @Autowired
    private DuibaHdtoolOptionsService duibaHdtoolOptionsService;
    @Autowired
    private HdtoolStockConsumeService hdtoolStockConsumeService;
    @Autowired
    private OperatingActivityOptionsService operatingActivityOptionsService;

    public void consumeDuibaHdtoolOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws Exception {
        DuibaHdtoolOptionsDto option = this.duibaHdtoolOptionsService.findOptionById(optionId);
        if (null == option) {
            throw new Exception("\u5956\u9879\u4e0d\u5b58\u5728");
        }
        if (option.getRemaining() != null && option.getRemaining() <= 0) {
            throw new Exception("\u5956\u9879\u5e93\u5b58\u4e0d\u8db3");
        }
        int ret = this.duibaHdtoolOptionsService.decrementOptionRemaining(option.getId());
        if (ret < 1) {
            throw new Exception("\u66f4\u65b0\u5151\u5427\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38,\u5956\u9879\u5e93\u5b58\u4e0d\u8db3");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
        hdtoolStock.setRelationId(option.getId());
        hdtoolStock.setRelationType("duiba");
        hdtoolStock.setAppId(appId);
        hdtoolStock.setAction("pay");
        hdtoolStock.setBizId(bizId);
        hdtoolStock.setBizSource(bizSource);
        hdtoolStock.setQuantity(Long.valueOf(1L));
        hdtoolStock.setGmtCreate(now);
        hdtoolStock.setGmtModified(now);
        this.hdtoolStockConsumeService.insert(hdtoolStock);
    }

    public void paybackDuibaHdtoolOptionStock(String bizId, String bizSource) throws Exception {
        HdtoolStockConsumeDto consume = this.hdtoolStockConsumeService.findByBizIdAndSourcePay(bizId, bizSource);
        if (null == consume) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        DuibaHdtoolOptionsDto option = this.duibaHdtoolOptionsService.findOptionById(consume.getRelationId());
        if (null == option) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        int ret = this.duibaHdtoolOptionsService.incrementOptionRemaining(option.getId());
        if (ret < 1) {
            throw new Exception("\u66f4\u65b0\u5151\u5427\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
        hdtoolStock.setRelationId(consume.getRelationId());
        hdtoolStock.setRelationType(consume.getRelationType());
        hdtoolStock.setAppId(consume.getAppId());
        hdtoolStock.setAction("back");
        hdtoolStock.setBizId(consume.getBizId());
        hdtoolStock.setBizSource(consume.getBizSource());
        hdtoolStock.setQuantity(consume.getQuantity());
        hdtoolStock.setGmtCreate(now);
        hdtoolStock.setGmtModified(now);
        this.hdtoolStockConsumeService.insert(hdtoolStock);
    }

    public void consumeAppHdtoolOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws Exception {
        OperatingActivityOptionsDto option = this.operatingActivityOptionsService.findOptionById(optionId);
        if (null == option) {
            throw new Exception("\u5956\u9879\u4e0d\u5b58\u5728");
        }
        if (option.getRemaining() != null && option.getRemaining() <= 0) {
            throw new Exception("\u5956\u9879\u5e93\u5b58\u4e0d\u8db3");
        }
        int ret = this.operatingActivityOptionsService.decrementOptionRemaining(optionId);
        if (ret < 1) {
            throw new Exception("\u66f4\u65b0\u5f00\u53d1\u8005\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
        hdtoolStock.setRelationId(option.getId());
        hdtoolStock.setRelationType("app");
        hdtoolStock.setAppId(appId);
        hdtoolStock.setAction("pay");
        hdtoolStock.setBizId(bizId);
        hdtoolStock.setBizSource(bizSource);
        hdtoolStock.setQuantity(Long.valueOf(1L));
        hdtoolStock.setGmtCreate(now);
        hdtoolStock.setGmtModified(now);
        this.hdtoolStockConsumeService.insert(hdtoolStock);
    }

    public void paybackAppHdtoolOptionStock(String bizId, String bizSource) throws Exception {
        HdtoolStockConsumeDto consume = this.hdtoolStockConsumeService.findByBizIdAndSourcePay(bizId, bizSource);
        if (null == consume) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        OperatingActivityOptionsDto option = this.operatingActivityOptionsService.findOptionById(consume.getRelationId());
        if (null == option) {
            throw new Exception("\u5956\u9879\u4e0d\u5b58\u5728");
        }
        int ret = this.operatingActivityOptionsService.incrementOptionRemaining(option.getId());
        if (ret < 1) {
            throw new Exception("\u66f4\u65b0\u5f00\u53d1\u8005\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        HdtoolStockConsumeDto hdtoolStock = new HdtoolStockConsumeDto(true);
        hdtoolStock.setRelationId(consume.getRelationId());
        hdtoolStock.setRelationType(consume.getRelationType());
        hdtoolStock.setAppId(consume.getAppId());
        hdtoolStock.setAction("back");
        hdtoolStock.setBizId(consume.getBizId());
        hdtoolStock.setBizSource(consume.getBizSource());
        hdtoolStock.setQuantity(Long.valueOf(1L));
        hdtoolStock.setGmtCreate(now);
        hdtoolStock.setGmtModified(now);
        this.hdtoolStockConsumeService.insert(hdtoolStock);
    }
}

