/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.core;

import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DatabaseHelper
implements ApplicationContextAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DatabaseHelper.class);
    private Map<String, BasicDataSource> dataSourceMap;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.dataSourceMap = applicationContext.getBeansOfType(BasicDataSource.class);
    }

    public void afterPropertiesSet() throws Exception {
        Thread dataSourceConnPoolPrintThread = new Thread(){

            @Override
            public void run() {
                int i = 0;
                do {
                    for (Map.Entry entry : DatabaseHelper.this.dataSourceMap.entrySet()) {
                        BasicDataSource ds = (BasicDataSource)entry.getValue();
                        if (!ds.isClosed()) {
                            int numIdleConnections = ds.getNumIdle();
                            int numConnections = ds.getNumActive();
                            int numBusyConnections = numConnections - numIdleConnections;
                            int max = ds.getMaxTotal();
                            if (numConnections >= max - 3 && numBusyConnections >= numConnections - 3) {
                                log.error("datasource [" + (String)entry.getKey() + "]'s connectionPool is too full,max:" + max + ",busy:" + numBusyConnections + ",idle:" + numIdleConnections);
                            }
                        }
                        ++i;
                    }
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (InterruptedException e) {
                        log.error("InterruptedException:", (Throwable)e);
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (!Thread.currentThread().isInterrupted());
            }
        };
        dataSourceConnPoolPrintThread.start();
    }
}

