/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.dao.singlelottery.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.singlelottery.SingleLotteryOrderDao;
import cn.com.duiba.activity.center.biz.entity.DeveloperActivityStatisticsEntity;
import cn.com.duiba.activity.center.biz.entity.singlelottery.SingleLotteryOrderEntity;
import cn.com.duiba.activity.center.biz.support.TableHelper;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class SingleLotteryOrderDaoImpl
extends ActivityBaseDao
implements SingleLotteryOrderDao {
    @Override
    public SingleLotteryOrderEntity find(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (SingleLotteryOrderEntity)((Object)this.selectOne("find", paramMap));
    }

    @Override
    public Integer countByConsumerIdAndOptionType(Long activityId, Long consumerId, Integer optionType) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("operatingActivityId", activityId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("optionType", optionType);
        return (Integer)this.selectOne("countByConsumerIdAndOptionType", paramMap);
    }

    @Override
    public List<SingleLotteryOrderEntity> findAllByIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.selectList("findAllByIds", paramMap);
    }

    @Override
    public Integer findLotteryCountByComsumer(Long activityId, Long appId, Long consumerId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("activityId", activityId);
        paramMap.put("appId", appId);
        paramMap.put("consumerId", consumerId);
        return (Integer)this.selectOne("findLotteryCountByComsumer", paramMap);
    }

    @Override
    public Integer findCountByComsumerTime(Long activityId, Long appId, Long consumerId, Date statTime, Date endTime) {
        HashMap<String, Comparable<Long>> paramMap = new HashMap<String, Comparable<Long>>();
        paramMap.put("activityId", activityId);
        paramMap.put("appId", appId);
        paramMap.put("consumerId", consumerId);
        paramMap.put("statTime", statTime);
        paramMap.put("endTime", endTime);
        return (Integer)this.selectOne("findCountByComsumerTime", paramMap);
    }

    @Override
    public List<SingleLotteryOrderEntity> findFrontLotteryList(Long activityId, Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("activityId", activityId);
        paramMap.put("appId", appId);
        return this.selectList("findFrontLotteryList", paramMap);
    }

    @Override
    public SingleLotteryOrderEntity findByAppAndDeveloperBizId(Long appId, String bizId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("bizId", bizId);
        return (SingleLotteryOrderEntity)((Object)this.selectOne("findByAppAndDeveloperBizId", paramMap));
    }

    @Override
    public List<SingleLotteryOrderEntity> findByIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.selectList("findByIds", paramMap);
    }

    @Override
    public List<SingleLotteryOrderEntity> findByInOrderIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.selectList("findByInOrderIds", paramMap);
    }

    @Override
    public List<SingleLotteryOrderEntity> findAllByLtGmtCreateAndExchangeStatus() {
        HashMap<String, Comparable<Date>> paramMap = new HashMap<String, Comparable<Date>>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, -1);
        Date endTime = cal.getTime();
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(endTime);
        cal1.add(5, -1);
        Date startTime = cal1.getTime();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", endTime);
        paramMap.put("exchangeStatus", Integer.valueOf(1));
        return this.selectList("findAllByLtGmtCreateAndExchangeStatus", paramMap);
    }

    @Override
    public List<DeveloperActivityStatisticsEntity> findFailCountByOperatingActivityIds(List<Long> operatingActivityIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("operatingActivityIds", operatingActivityIds);
        return this.selectList("findFailCountByOperatingActivityIds", paramMap);
    }

    @Override
    public List<SingleLotteryOrderEntity> findByLimit(Map<String, Object> paramMap) {
        return this.selectList("findByLimit", paramMap);
    }

    @Override
    public Long findByCount(Map<String, Object> paramMap) {
        return (Long)this.selectOne("findByCount", paramMap);
    }

    @Override
    public Integer countWintimesByOptionType(List<Long> operatingActivityIds, Date statTime, Date endTime, Integer optionType) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("operatingActivityIds", operatingActivityIds);
        paramMap.put("statTime", statTime);
        paramMap.put("endTime", endTime);
        paramMap.put("optionType", optionType);
        return (Integer)this.selectOne("countWintimesByOptionType", paramMap);
    }

    @Override
    public List<SingleLotteryOrderEntity> getWinningListByOperatingActivityIds(Collection<Long> operatingActivityIds) {
        HashMap<String, Collection<Long>> paramMap = new HashMap<String, Collection<Long>>();
        paramMap.put("operatingActivityIds", operatingActivityIds);
        return this.selectList("getWinningListByOperatingActivityIds", paramMap);
    }

    @Override
    public int updateExchangeStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", 3);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        return this.update("updateExchangeStatusToFail", paramMap);
    }

    @Override
    public int updateExchangeStatusToOverdue(long id, String error4admin, String error4developer, String error4consumer) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("exchangeStatus", 4);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        return this.update("updateExchangeStatusToOverdue", paramMap);
    }

    @Override
    public int updateStatusToSuccess(long id) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("status", 1);
        paramMap.put("exchangeStatus", 1);
        return this.update("updateStatusToSuccess", paramMap);
    }

    @Override
    public int updateStatusToFail(long id, String error4admin, String error4developer, String error4consumer) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", 2);
        paramMap.put("error4admin", TableHelper.subString(error4admin, 200));
        paramMap.put("error4developer", TableHelper.subString(error4developer, 200));
        paramMap.put("error4consumer", TableHelper.subString(error4consumer, 200));
        return this.update("updateStatusToFail", paramMap);
    }

    @Override
    public int updatePrizeTypeToThanks(long id) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", 1);
        paramMap.put("prizeName", "\u8c22\u8c22\u53c2\u4e0e");
        paramMap.put("exchangeStatus", 2);
        paramMap.put("optionType", 0);
        return this.update("updatePrizeTypeToThanks", paramMap);
    }

    @Override
    public Integer doTakePrize(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.update("doTakePrize", paramMap);
    }

    @Override
    public Integer rollbackTakePrize(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.update("rollbackTakePrize", paramMap);
    }

    @Override
    public Integer updateLotteryResult(Long id, Long appItemId, Long itemId, String prizeName, String prizeType, String prizeDegree, Integer prizeFacePrice, Integer optionType, Long couponId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("appItemId", appItemId);
        paramMap.put("itemId", itemId);
        paramMap.put("prizeName", prizeName);
        paramMap.put("prizeType", prizeType);
        paramMap.put("prizeDegree", prizeDegree);
        paramMap.put("prizeFacePrice", prizeFacePrice);
        paramMap.put("optionType", optionType);
        paramMap.put("couponId", couponId);
        paramMap.put("status", 1);
        paramMap.put("exchangeStatus", 1);
        return this.update("updateLotteryResult", paramMap);
    }

    @Override
    public int updateDeveloperBizId(long id, String bizId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("bizId", bizId);
        return this.update("updateDeveloperBizId", paramMap);
    }

    @Override
    public int updateMainOrderId(long id, Long orderId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        paramMap.put("orderId", orderId);
        return this.update("updateMainOrderId", paramMap);
    }

    @Override
    public void insert(SingleLotteryOrderEntity singleLotteryOrderDO) {
        this.insert("insert", (Object)singleLotteryOrderDO);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

