/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.job;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigDto;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobSeckillBo;
import cn.com.duiba.activity.center.biz.domain.PushAppsConfig;
import cn.com.duiba.activity.center.biz.entity.config.CenterConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.service.config.CenterConfigService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
import cn.com.duiba.activity.center.common.util.AppLogUtil;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.simple.AbstractSimpleElasticJob;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TodayRobSeckillRestartJob
extends AbstractSimpleElasticJob {
    private static Logger log = LoggerFactory.getLogger(TodayRobSeckillRestartJob.class);
    @Autowired
    private TodayRobSeckillService todayRobSeckillService;
    @Autowired
    private TodayRobSeckillBo todayRobSeckillBo;
    @Autowired
    private CenterConfigService centerConfigService;

    public void process(JobExecutionMultipleShardingContext shardingContext) {
        AppLogUtil.warn((Logger)log, (String)"################# \u4eca\u65e5\u5fc5\u62a2\u79d2\u6740\u514d\u5355\u5b9a\u65f6\u4efb\u52a1-\u79d2\u6740\u4efb\u52a1\u63a8\u9001\u8865\u507f\uff0c\u5f00\u59cb\u6267\u884c #################");
        List<TodayRobSeckillConfigEntity> list = this.todayRobSeckillService.findUnsuccessPushList();
        if (CollectionUtils.isEmpty(list)) {
            AppLogUtil.warn((Logger)log, (String)"\u6ca1\u6709\u9700\u8981\u8865\u507f\u7684\u63a8\u9001\u4efb\u52a1");
            return;
        }
        CenterConfigEntity entity = this.centerConfigService.findPushAppsConfig();
        PushAppsConfig pushAppsConfig = new PushAppsConfig(entity);
        List<Long> appIdList = pushAppsConfig.getAppIdList();
        if (CollectionUtils.isEmpty(appIdList)) {
            AppLogUtil.warn((Logger)log, (String)"\u6ca1\u6709\u914d\u7f6e\u63a8\u9001app\u5217\u8868");
            return;
        }
        this.todayRobSeckillBo.pushSeckillActivity(BeanUtils.copyList(list, TodayRobSeckillConfigDto.class), appIdList);
        AppLogUtil.warn((Logger)log, (String)"################# \u4eca\u65e5\u5fc5\u62a2\u79d2\u6740\u514d\u5355\u5b9a\u65f6\u4efb\u52a1-\u79d2\u6740\u4efb\u52a1\u63a8\u9001\u8865\u507f\uff0c\u6267\u884c\u7ed3\u675f #################");
    }
}

