/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.kafka;

import cn.com.duiba.activity.center.biz.kafka.KafkaClient;
import cn.com.duiba.activity.center.biz.kafka.Message;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageService.class);
    @Autowired
    private KafkaClient kafkaClient;

    public String sendMsg(String queueName, Message message) throws Exception {
        String json = JSONObject.toJSONString((Object)message);
        if (json.length() > message.getMaxBodyBytes()) {
            log.error("queueName:" + queueName + ",json:[" + json + "] is too long,current:" + json.length() + ",max:" + message.getMaxBodyBytes() + ",will not send");
        }
        Exception ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                String msgId = this.kafkaClient.sendMsg(queueName, json);
                return msgId;
            }
            catch (Exception e) {
                ex = e;
                continue;
            }
        }
        if (null != ex) {
            throw ex;
        }
        return null;
    }

    public String sendMsg(String queueName, String message, Integer maxBoyBytes) throws Exception {
        if (message.length() > maxBoyBytes) {
            log.error("queueName:" + queueName + ",json:[" + message + "] is too long,current:" + message.length() + ",max:" + maxBoyBytes + ",will not send");
        }
        Exception ex = null;
        for (int i = 0; i < 3; ++i) {
            try {
                String msgId = this.kafkaClient.sendMsg(queueName, message);
                return msgId;
            }
            catch (Exception e) {
                ex = e;
                continue;
            }
        }
        if (null != ex) {
            throw ex;
        }
        return null;
    }
}

