/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.plugin.buckle.impl;

import cn.com.duiba.activity.center.api.dto.other.NotifyQueueDO;
import cn.com.duiba.activity.center.biz.constant.Environment;
import cn.com.duiba.activity.center.biz.dao.other.DuibaRemainingMoneyDAO;
import cn.com.duiba.activity.center.biz.dao.other.NotifyQueueDAOImpl;
import cn.com.duiba.activity.center.biz.kafka.MessageService;
import cn.com.duiba.activity.center.biz.kafka.TopicConstant;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCreditsCallback;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerCutCreditsService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumeCreditsFailEvent;
import cn.com.duiba.activity.center.biz.plugin.event.credits.ConsumerCreditsSuccessEvent;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.chaos.ActPreStockSerivce;
import cn.com.duiba.activity.center.biz.service.gamecommon.CustomerGameAppService;
import cn.com.duiba.activity.center.biz.service.prize.ActivityPrizeOptionService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.activity.center.biz.tools.AssembleTool;
import cn.com.duiba.activity.center.biz.tools.service.ActualPriceCalService;
import cn.com.duiba.activity.center.biz.tools.service.FrequentExchangeLimitService;
import cn.com.duiba.activity.center.biz.tools.service.ItemKeyStockServcie;
import cn.com.duiba.activity.center.biz.tools.service.TimeLimitService;
import cn.com.duiba.credits.sdk.CreditConsumeParams;
import cn.com.duiba.dcommons.flowwork.ActivityLotteryFlowworkService;
import cn.com.duiba.notifycenter.client.NotifyCenterServiceClient;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.item.remoteservice.RemoteItemKeyService;
import cn.com.duiba.service.remoteservice.RemoteAddrLimitService;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import cn.com.duiba.stock.service.api.remoteservice.RemoteStockService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ConsumerCutCreditsServiceImpl
implements ConsumerCutCreditsService {
    private static Logger log = LoggerFactory.getLogger(ConsumerCutCreditsServiceImpl.class);
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TopicConstant topicConstant;
    @Autowired
    private ConsumerCreditsCallback consumerCreditsCallback;
    @Autowired
    private ActivityPrizeOptionService activityPrizeOptionService;
    @Autowired
    private RemoteStockService remoteStockService;
    @Autowired
    private RemoteItemKeyService remoteItemKeyService;
    @Autowired
    private TimeLimitService timeLimitService;
    @Autowired
    private ItemKeyStockServcie itemKeyStockServcie;
    @Autowired
    private RemoteAddrLimitService remoteAddrLimitService;
    @Autowired
    private ActualPriceCalService actualPriceCalService;
    @Autowired
    private DuibaRemainingMoneyDAO duibaRemainingMoneyDAO;
    @Autowired
    private FrequentExchangeLimitService frequentExchangeLimit;
    @Autowired
    @Qualifier(value="notifyQueueDAO")
    private NotifyQueueDAOImpl notifyQueueDAO;
    @Autowired
    private NotifyCenterServiceClient notifyCenterServiceClient;
    @Autowired
    private ActivityLotteryFlowworkService activityLotteryFlowworkService;
    @Autowired
    private ActPreStockSerivce actPreStockSerivce;
    @Autowired
    private CustomerGameAppService customerGameAppService;

    @Override
    public void asyncConsumerCredits(Long consumerId, String orderNum, String transer, String ip, String description) {
        DubboResult order = this.remoteActivityOrderService.findByOrderNum(orderNum);
        if (!order.isSuccess() || order.getResult() == null) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setRelationId(orderNum);
            message.setConsumerId(String.valueOf(consumerId));
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            message.setMessage("\u8ba2\u5355\u4e0d\u5b58\u5728");
            this.onCreditsFail(message, new ActivityOrderDto());
            return;
        }
        if (((ActivityOrderDto)order.getResult()).getConsumeCreditsStatus() != 1) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            this.onCreditsSuccess(message);
            return;
        }
        if (((ActivityOrderDto)order.getResult()).getConsumeCredits() <= 0L) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
            message.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
            message.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
            HashMap params = Maps.newHashMap();
            params.put("ip", ip);
            message.setParams((Map)params);
            this.onCreditsSuccess(message);
            return;
        }
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        AppDO app = this.remoteAppService.find(consumer.getAppId());
        CreditConsumeParams p = new CreditConsumeParams();
        p.setAppKey(app.getAppKey());
        p.setCredits(((ActivityOrderDto)order.getResult()).getConsumeCredits());
        p.setOrderNum("activity-" + ((ActivityOrderDto)order.getResult()).getOrderNum());
        p.setUid(consumer.getPartnerUserId());
        p.setTimestamp(new Date());
        p.setType(((ActivityOrderDto)order.getResult()).getActivityType());
        p.setIp(((ActivityOrderDto)order.getResult()).getIp());
        p.setFacePrice(Integer.valueOf(0));
        p.setActualPrice(Integer.valueOf(0));
        p.setDescription(description);
        if (StringUtils.isNotBlank((CharSequence)transer)) {
            p.setTransfer(transer);
        }
        Map map = p.toRequestMap(app.getAppSecret());
        CreditsMessage mq = new CreditsMessage();
        mq.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        mq.setAppId(((ActivityOrderDto)order.getResult()).getAppId().toString());
        mq.setConsumerId(((ActivityOrderDto)order.getResult()).getConsumerId().toString());
        mq.setRelationId(((ActivityOrderDto)order.getResult()).getOrderNum());
        mq.setRelationType(((ActivityOrderDto)order.getResult()).getActivityType());
        HashMap params = Maps.newHashMap();
        params.put("ip", ip);
        mq.setParams((Map)params);
        if ("baiduyun".equals(Environment.getPlace())) {
            mq.setHttpUrl(app.getCreditsConsumeRequestUrl());
            mq.setHttpType("post");
            mq.setAuthParams(map);
        } else {
            String url = AssembleTool.assembleUrl(app.getCreditsConsumeRequestUrl(), map);
            mq.setHttpUrl(url);
            mq.setHttpType("get");
        }
        String str = JSONObject.toJSONString((Object)mq);
        try {
            log.error("->>\u53d1\u9001kafka\u6263\u79ef\u5206\u4fe1\u606f," + str);
            this.messageService.sendMsg(this.topicConstant.getTopicConsumerCredits(), str, 2000);
        }
        catch (Exception e) {
            CreditsCallbackMessage message = new CreditsCallbackMessage();
            message.setRelationId(orderNum);
            message.setConsumerId(String.valueOf(consumerId));
            HashMap param = Maps.newHashMap();
            param.put("ip", ip);
            message.setParams((Map)param);
            message.setMessage("\u53d1\u9001kafka\u6263\u79ef\u5206\u4fe1\u606f\u5f02\u5e38" + e);
            this.onCreditsFail(message, null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreditsFail(CreditsCallbackMessage message, ActivityOrderDto order) {
        try {
            this.remoteActivityOrderService.consumeCreditsFail(order.getOrderNum(), null, null, null, null, null, null, null, null, null, "\u6263\u79ef\u5206\u5931\u8d25\uff0c\u5f00\u53d1\u8005\u670d\u52a1\u5668\u5f02\u5e38\u3002" + message.getMessage(), "\u6263\u79ef\u5206\u5931\u8d25\uff0c" + message.getMessage(), "\u6263\u79ef\u5206\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            if (null != order && order.getConsumeCredits() > 0L) {
                this.remoteConsumerService.increaseCredits(order.getConsumerId(), order.getConsumeCredits());
            }
        }
        catch (Exception e) {
            log.error("\u6d3b\u52a8\u62bd\u5956\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            this.complete(message.getRelationId());
            DuibaEventsDispatcher.get().dispatchConsumeCreditsFailEvent(new ConsumeCreditsFailEvent(order, new Exception("\u6263\u79ef\u5206\u5931\u8d25")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreditsSuccess(CreditsCallbackMessage message) {
        ActivityOrderDto orderNew = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(message.getRelationId()).getResult();
        try {
            this.remoteActivityOrderService.consumeCreditsSuccess(message.getRelationId(), null, null, null, null, null, null, null, null, null);
            if ("littleGame" == orderNew.getActivityType()) {
                this.customerGameAppService.updateIsBuy(orderNew.getDuibaActivityId(), orderNew.getConsumerId(), orderNew.getAppId());
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u6263\u79ef\u5206\u8ba2\u5355\u72b6\u6001\u5f02\u5e38:", (Throwable)e);
        }
        finally {
            this.complete(message.getRelationId());
            DuibaEventsDispatcher.get().dispatchConsumeCreditsSuccessEvent(new ConsumerCreditsSuccessEvent(orderNew));
        }
    }

    public void complete(String orderNum) {
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        this.insertHdtoolOrderNotifyQueueIfNesscery(order);
        if (order.getConsumeCreditsStatus() == 2) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderSuccess, order));
        } else if (order.getConsumeCreditsStatus() == 3) {
            DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderFail, order));
        }
    }

    private void insertHdtoolOrderNotifyQueueIfNesscery(ActivityOrderDto order) {
        try {
            if (order.getConsumeCredits() <= 0L) {
                return;
            }
            if (order.getConsumeCreditsStatus() == 1) {
                return;
            }
            ConsumerDO consumer = this.remoteConsumerService.find(order.getConsumerId());
            NotifyQueueDO nq = new NotifyQueueDO();
            nq.setAppId(order.getAppId());
            nq.setConsumerId(order.getConsumerId());
            nq.setDeveloperBizId(order.getDeveloperBizId());
            nq.setDuibaOrderNum("activity-" + order.getOrderNum());
            if (order.getError4developer() != null) {
                nq.setError4developer(order.getError4developer());
            }
            nq.setNextTime(new Date());
            nq.setPartnerUserId(consumer.getPartnerUserId());
            nq.setRelationId(order.getDuibaActivityId());
            nq.setRelationType("rob");
            nq.setTimes(Integer.valueOf(0));
            nq.setResult(Boolean.valueOf(order.getConsumeCreditsStatus() == 2));
            this.notifyQueueDAO.insert(nq);
            this.notifyCenterServiceClient.notifyImmediately(nq.getId());
        }
        catch (Exception e) {
            log.error("insertHdtoolOrderNotifyQueueIfNesscery error", (Throwable)e);
        }
    }

    @Override
    public void creditsCallback(CreditsCallbackMessage message) {
        if (null == message || StringUtils.isBlank((CharSequence)message.getRelationId())) {
            return;
        }
        DubboResult orderResult = this.remoteActivityOrderService.findByOrderNum(message.getRelationId());
        if (!orderResult.isSuccess() || orderResult.getResult() == null) {
            return;
        }
        ActivityOrderDto order = (ActivityOrderDto)orderResult.getResult();
        if (order.getConsumeCreditsStatus() != 1) {
            return;
        }
        if ("completed".equals(message.getCallbackType())) {
            this.consumerCreditsCallback.completed(message);
        } else if ("failed".equals(message.getCallbackType())) {
            this.consumerCreditsCallback.failed(message);
        } else if ("cancelled".equals(message.getCallbackType())) {
            this.consumerCreditsCallback.cancelled(message);
        }
    }
}

