/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.creditgame;

import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.creditgame.CreditGameSkinTemplateDto;
import cn.com.duiba.activity.center.api.remoteservice.creditgame.RemoteCreditGameSkinTemplateService;
import cn.com.duiba.activity.center.biz.entity.creditgame.CreditGameSkinTemplateEntity;
import cn.com.duiba.activity.center.biz.service.creditgame.CreditGameSkinTemplateService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteCreditGameSkinTemplateServiceImpl
implements RemoteCreditGameSkinTemplateService {
    @Resource
    private CreditGameSkinTemplateService creditGameSkinTemplateService;
    private static Logger log = LoggerFactory.getLogger(RemoteCreditGameSkinTemplateServiceImpl.class);

    public DubboResult<CreditGameSkinTemplateDto> find(Long id) {
        try {
            CreditGameSkinTemplateDto rs;
            Preconditions.checkNotNull((Object)id, (Object)"id is null");
            CreditGameSkinTemplateEntity entity = (CreditGameSkinTemplateEntity)this.creditGameSkinTemplateService.queryById(id);
            if (entity != null) {
                rs = new CreditGameSkinTemplateDto();
                ObjectUtil.convert((Object)entity, (Object)rs);
            } else {
                rs = null;
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("find() error,id=" + id, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CreditGameSkinTemplateDto>> findPage(PagingParameters pagingParameters) {
        try {
            ArrayList rs;
            List<CreditGameSkinTemplateEntity> entity;
            Integer offset = pagingParameters.getOffset();
            Integer max = pagingParameters.getMax();
            if (offset == null) {
                offset = 0;
            }
            if (max == null) {
                max = 20;
            }
            if (CollectionUtils.isNotEmpty(entity = this.creditGameSkinTemplateService.queryByPage(offset, max))) {
                rs = Lists.newArrayListWithCapacity((int)entity.size());
                ObjectUtil.convertList(entity, (List)rs, CreditGameSkinTemplateDto.class);
            } else {
                rs = Lists.newArrayList();
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("findPage() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> add(CreditGameSkinTemplateDto dto) {
        try {
            Preconditions.checkNotNull((Object)dto, (Object)"dto is null");
            CreditGameSkinTemplateEntity entity = new CreditGameSkinTemplateEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            int record = this.creditGameSkinTemplateService.insert(entity);
            if (record == 1) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)("\u6dfb\u52a0\u8bb0\u5f55\u4e3a" + record));
        }
        catch (Exception e) {
            log.error("add() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> edit(CreditGameSkinTemplateDto dto) {
        try {
            Preconditions.checkNotNull((Object)dto, (Object)"dto is null");
            CreditGameSkinTemplateEntity entity = new CreditGameSkinTemplateEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            int record = this.creditGameSkinTemplateService.update(entity);
            if (record == 1) {
                return DubboResult.successResult((Object)Boolean.TRUE);
            }
            return DubboResult.failResult((String)("\u66f4\u65b0\u8bb0\u5f55\u4e3a" + record));
        }
        catch (Exception e) {
            log.error("edit() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> isTitleExist(String name) {
        try {
            Preconditions.checkNotNull((Object)name, (Object)"name is null");
            Long count = this.creditGameSkinTemplateService.queryCountByName(name);
            boolean rs = count > 0L;
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("isTitleExist() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<CreditGameSkinTemplateDto>> findByType(Byte type) {
        try {
            ArrayList rs;
            Preconditions.checkNotNull((Object)type, (Object)"type is null");
            List<CreditGameSkinTemplateEntity> entity = this.creditGameSkinTemplateService.queryByType(type);
            if (CollectionUtils.isNotEmpty(entity)) {
                rs = Lists.newArrayListWithCapacity((int)entity.size());
                ObjectUtil.convertList(entity, (List)rs, CreditGameSkinTemplateDto.class);
            } else {
                rs = Lists.newArrayList();
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("findByType() error,type=" + type, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> findCount() {
        try {
            Long rs = this.creditGameSkinTemplateService.queryCount();
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("findCount() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

