/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.gameskin;

import cn.com.duiba.activity.center.api.dto.PagingParameters;
import cn.com.duiba.activity.center.api.dto.gameskin.GameSkinDto;
import cn.com.duiba.activity.center.api.remoteservice.gameskin.RemoteGameSkinService;
import cn.com.duiba.activity.center.biz.entity.gameskin.GameSkinEntity;
import cn.com.duiba.activity.center.biz.service.gameskin.GameSkinService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemoteGameSkinServiceImpl
implements RemoteGameSkinService {
    private static Logger log = LoggerFactory.getLogger(RemoteGameSkinServiceImpl.class);
    @Resource
    private GameSkinService gameSkinService;

    public DubboResult<GameSkinDto> find(Long id) {
        try {
            GameSkinDto rs;
            GameSkinEntity entity = this.gameSkinService.selectById(id);
            if (entity == null) {
                rs = null;
            } else {
                rs = new GameSkinDto();
                ObjectUtil.convert((Object)entity, (Object)rs);
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.find(" + id + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GameSkinDto>> findPage(PagingParameters pagingParameters, List<Byte> types) {
        try {
            ArrayList rs;
            List<GameSkinEntity> entity;
            Integer offset = pagingParameters.getOffset();
            Integer max = pagingParameters.getMax();
            if (offset == null) {
                offset = 0;
            }
            if (max == null) {
                max = 20;
            }
            if ((entity = this.gameSkinService.selectByPage(offset, max, types)) == null) {
                rs = null;
            } else {
                rs = Lists.newArrayList();
                ObjectUtil.convertList(entity, (List)rs, GameSkinDto.class);
            }
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.findPage(" + pagingParameters.getOffset() + pagingParameters.getMax() + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<List<GameSkinDto>> findByType(Byte type) {
        try {
            ArrayList rs;
            List<GameSkinEntity> entity = this.gameSkinService.selectByType(type);
            if (CollectionUtils.isEmpty(entity)) {
                rs = null;
            } else {
                rs = Lists.newArrayListWithCapacity((int)entity.size());
                ObjectUtil.convertList(entity, (List)rs, GameSkinDto.class);
            }
            log.error(((Object)rs).toString());
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.findByType(" + type + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> add(GameSkinDto dto) {
        try {
            GameSkinEntity entity = new GameSkinEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            Long id = this.gameSkinService.insert(entity);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.add(" + dto.toString() + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> edit(GameSkinDto dto) {
        try {
            if (dto.getId() == null) {
                throw new Exception("id is null!!!");
            }
            GameSkinEntity entity = new GameSkinEntity();
            ObjectUtil.convert((Object)dto, (Object)entity);
            Long id = this.gameSkinService.update(entity);
            return DubboResult.successResult((Object)id);
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.edit(" + dto.toString() + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> isTitleExist(String name) {
        try {
            Long count = this.gameSkinService.selectCount(name, null);
            Boolean rs = count > 0L ? Boolean.TRUE : Boolean.FALSE;
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.isTitleExist(" + name + ") error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> findCount(List<Byte> types) {
        try {
            Long rs = this.gameSkinService.selectCount(null, types);
            return DubboResult.successResult((Object)rs);
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.findCount() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<String> getBrickContentById(Long id) {
        try {
            return DubboResult.successResult((Object)this.gameSkinService.getBrickContentById(id));
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.getBrickContentById() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<GameSkinDto> findNoContent(Long id) {
        try {
            return DubboResult.successResult((Object)this.gameSkinService.findNoContent(id));
        }
        catch (Exception e) {
            log.error("RemoteGameSkinService.findNoContent() error", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

