/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.rob;

import cn.com.duiba.activity.center.api.dto.rob.TodayRobConfigDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.RemoteTodayRobConfigService;
import cn.com.duiba.activity.center.biz.bo.activity.ActivityBo;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobConfigService;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteTodayRobConfigServiceImpl
implements RemoteTodayRobConfigService {
    @Autowired
    private TodayRobConfigService todayRobConfigService;
    @Autowired
    private ActivityBo activityBo;

    public DubboResult<TodayRobConfigDto> find(Long configId) {
        return DubboResult.successResult((Object)this.todayRobConfigService.find(configId));
    }

    public DubboResult<Long> saveOrUpdateTodayRobConfig(TodayRobConfigDto todayRobConfigDto) {
        Long id = this.todayRobConfigService.saveOrUpdateTodayRobConfig(todayRobConfigDto);
        return DubboResult.successResult((Object)id);
    }

    public DubboResult<List<TodayRobConfigDto>> findTodayRobConfigPage(Map<String, Object> params) {
        return DubboResult.successResult(this.todayRobConfigService.findTodayRobConfigPage(params));
    }

    public DubboResult<Integer> findTodayRobConfigCount(Map<String, Object> params) {
        return DubboResult.successResult((Object)this.todayRobConfigService.findTodayRobConfigCount(params));
    }

    public DubboResult<Boolean> delTodayRobConfig(Long configId) {
        return DubboResult.successResult((Object)this.todayRobConfigService.delTodayRobConfig(configId));
    }

    public DubboResult<Boolean> statusChange(Long configId, Integer status) {
        return DubboResult.successResult((Object)this.todayRobConfigService.statusChange(configId, status));
    }

    public DubboResult<List<TodayRobConfigDto>> findSortTodayRobConfig(Integer offset, Integer pageSize) {
        return DubboResult.successResult(this.todayRobConfigService.findSortTodayRobConfig(offset, pageSize));
    }

    public DubboResult<Boolean> accessSticky(Long id) {
        TodayRobConfigDto dto = this.todayRobConfigService.find(id);
        if (null == dto) {
            return DubboResult.successResult((Object)false);
        }
        dto.openSwitch(TodayRobConfigDto.SWITCHES_TOP.intValue());
        return DubboResult.successResult((Object)this.todayRobConfigService.updateStickyTime(id, dto.getSwitches(), new Date()));
    }

    public DubboResult<Boolean> cancelSticky(Long id) {
        TodayRobConfigDto dto = this.todayRobConfigService.find(id);
        if (null == dto) {
            return DubboResult.successResult((Object)false);
        }
        dto.closeSwitch(TodayRobConfigDto.SWITCHES_TOP.intValue());
        return DubboResult.successResult((Object)this.todayRobConfigService.updateStickyTime(id, dto.getSwitches(), dto.getGmtCreate()));
    }

    public DubboResult<String> cutPrice(Long todayRobConfigId, String activityType, Long consumerId, String ip, String ua, String transfer) {
        try {
            String orderNum = this.activityBo.cutPrice(todayRobConfigId, activityType, consumerId, ip, ua, transfer);
            return DubboResult.successResult((Object)orderNum);
        }
        catch (Exception e) {
            if (e instanceof StatusException) {
                return DubboResult.failResult((String)((StatusException)e).getMessage());
            }
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> updateAllTopSwitches() {
        return DubboResult.successResult((Object)this.todayRobConfigService.updateAllTopSwitches());
    }
}

