/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.remoteservice.impl.rob;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillListDto;
import cn.com.duiba.activity.center.api.remoteservice.rob.RemoteTodayRobSeckillBackendService;
import cn.com.duiba.activity.center.biz.bo.rob.TodayRobSeckillBo;
import cn.com.duiba.activity.center.biz.domain.PushAppsConfig;
import cn.com.duiba.activity.center.biz.entity.config.CenterConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillConfigEntity;
import cn.com.duiba.activity.center.biz.entity.rob.TodayRobSeckillEntity;
import cn.com.duiba.activity.center.biz.service.config.CenterConfigService;
import cn.com.duiba.activity.center.biz.service.rob.TodayRobSeckillService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duiba.wolf.utils.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteTodayRobSeckillBackendServiceImpl
implements RemoteTodayRobSeckillBackendService {
    Logger log = LoggerFactory.getLogger(RemoteTodayRobSeckillBackendServiceImpl.class);
    @Autowired
    private TodayRobSeckillService todayRobSeckillService;
    @Autowired
    private TodayRobSeckillBo todayRobSeckillBo;
    @Autowired
    private CenterConfigService centerConfigService;

    public DubboResult<List<TodayRobSeckillConfigDto>> findSeckillConfigs(Long todayRobSeckillId) {
        try {
            ArrayList list = new ArrayList();
            List<TodayRobSeckillConfigEntity> ret = this.todayRobSeckillService.findSeckillConfigs(todayRobSeckillId);
            ObjectUtil.convertList(ret, list, TodayRobSeckillConfigDto.class);
            return DubboResult.successResult(list);
        }
        catch (Exception e) {
            this.log.error("todayRobSeckillId=" + todayRobSeckillId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<TodayRobSeckillDto> findSeckillById(Long todayRobSeckillId) {
        try {
            TodayRobSeckillDto trd = new TodayRobSeckillDto();
            TodayRobSeckillEntity trs = this.todayRobSeckillService.findSeckillById(todayRobSeckillId);
            ObjectUtil.convert((Object)trs, (Object)trd);
            return DubboResult.successResult((Object)trd);
        }
        catch (Exception e) {
            this.log.error("todayRobSeckillId=" + todayRobSeckillId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> seveSeckillConfigs(List<TodayRobSeckillConfigDto> list, TodayRobSeckillDto todayRobSeckillDto) {
        try {
            return DubboResult.successResult((Object)this.todayRobSeckillBo.seveSeckillConfigs(list, todayRobSeckillDto));
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<PaginationDto<TodayRobSeckillListDto>> findTodayRobSeckillList(int pageNum, int pageSize) {
        try {
            return DubboResult.successResult(this.todayRobSeckillBo.findTodayRobSeckillList(pageNum, pageSize));
        }
        catch (Exception e) {
            this.log.error("", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> delTodayRobSeckill(long todayRobSeckillId) {
        try {
            return DubboResult.successResult((Object)this.todayRobSeckillService.delTodayRobSeckill(todayRobSeckillId));
        }
        catch (Exception e) {
            this.log.error("todayRobSeckillId=" + todayRobSeckillId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> enableTodayRobSeckill(long todayRobSeckillId, boolean enable) {
        try {
            return DubboResult.successResult((Object)this.todayRobSeckillBo.enableTodayRobSeckill(todayRobSeckillId, enable));
        }
        catch (Exception e) {
            this.log.error("todayRobSeckillId=" + todayRobSeckillId + ",enable=" + enable, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Void> updatePushApps(List<Long> appIdList) {
        try {
            CenterConfigEntity centerConfigEntity = this.centerConfigService.findPushAppsConfig();
            PushAppsConfig pushAppsConfig = new PushAppsConfig(centerConfigEntity);
            List<Long> existAppIdList = pushAppsConfig.getAppIdList();
            this.centerConfigService.updatePushAppsConfig(appIdList);
            appIdList.removeAll(existAppIdList);
            List<Long> todayRobSeckillIds = this.todayRobSeckillService.findEnableTodayRobSeckillIds();
            List<TodayRobSeckillConfigEntity> list = this.todayRobSeckillService.findSeckillConfigByIdss(todayRobSeckillIds);
            this.todayRobSeckillBo.pushSeckillActivity(BeanUtils.copyList(list, TodayRobSeckillConfigDto.class), appIdList);
            return DubboResult.successResult(null);
        }
        catch (Exception e) {
            this.log.error("appIdList=" + appIdList, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

