/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.commonactivity.impl;

import cn.com.duiba.activity.center.api.dto.activity.OperatingActivityDto;
import cn.com.duiba.activity.center.api.enums.DuibaActivityTypeEnum;
import cn.com.duiba.activity.center.biz.constant.DomainConfigureConstant;
import cn.com.duiba.activity.center.biz.dao.activity.OperatingActivityDao;
import cn.com.duiba.activity.center.biz.entity.activity.OperatingActivityEntity;
import cn.com.duiba.activity.center.biz.service.commonactivity.ActivityToolService;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaActivityToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaGuessToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaHdtoolToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaNgameToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaQuestionAnswerToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaQuizzToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaSeckillToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaSecondsKillActivityToolServiceImpl;
import cn.com.duiba.activity.center.biz.service.commonactivity.impl.DuibaSingleLotteryToolServiceImpl;
import cn.com.duiba.dcommons.domain.Tuple;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activityToolService")
public class ActivityToolServiceImpl
implements ActivityToolService {
    @Autowired
    private DuibaActivityToolServiceImpl duibaActivityToolServiceImpl;
    @Autowired
    private DuibaGuessToolServiceImpl duibaGuessToolServiceImpl;
    @Autowired
    private DuibaHdtoolToolServiceImpl duibaHdtoolToolServiceImpl;
    @Autowired
    private DuibaNgameToolServiceImpl duibaNgameToolServiceImpl;
    @Autowired
    private DuibaQuestionAnswerToolServiceImpl duibaQuestionAnswerToolServiceImpl;
    @Autowired
    private DuibaQuizzToolServiceImpl duibaQuizzToolServiceImpl;
    @Autowired
    private DuibaSeckillToolServiceImpl duibaSeckillToolServiceImpl;
    @Autowired
    private DuibaSecondsKillActivityToolServiceImpl duibaSecondsKillActivityToolServiceImpl;
    @Autowired
    private DuibaSingleLotteryToolServiceImpl duibaSingleLotteryToolServiceImpl;
    @Autowired
    private OperatingActivityDao operatingActivityDao;

    private ActivityToolService.ActivityToolServiceAdapter service(DuibaActivityTypeEnum type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case DUIBA_ACTIVITY: {
                return this.duibaActivityToolServiceImpl;
            }
            case DUIBA_GUESS: {
                return this.duibaGuessToolServiceImpl;
            }
            case DUIBA_HDTOOL: {
                return this.duibaHdtoolToolServiceImpl;
            }
            case DUIBA_NGAME: {
                return this.duibaNgameToolServiceImpl;
            }
            case DUIBA_QUESTION_ANSWER: {
                return this.duibaQuestionAnswerToolServiceImpl;
            }
            case DUIBA_QUIZZ: {
                return this.duibaQuizzToolServiceImpl;
            }
            case DUIBA_SECKILL: {
                return this.duibaSeckillToolServiceImpl;
            }
            case DUIBA_SECONDS_KILL_ACTIVITY: {
                return this.duibaSecondsKillActivityToolServiceImpl;
            }
            case DUIBA_SINGLE_LOTTERY: {
                return this.duibaSingleLotteryToolServiceImpl;
            }
        }
        return null;
    }

    @Override
    public String getTitle(Long activityId, DuibaActivityTypeEnum type) {
        ActivityToolService.ActivityToolServiceAdapter service = this.service(type);
        if (service == null) {
            throw new RuntimeException("\u7c7b\u578b\u53c2\u6570\u4e0d\u5168");
        }
        return service.getTitle(activityId);
    }

    @Override
    public Map<Long, String> getMobileUrlMap(List<Tuple.Tuple2<Integer, Long>> activities) {
        if (CollectionUtils.isEmpty(activities)) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> urlMap = new HashMap<Long, String>();
        for (Tuple.Tuple2<Integer, Long> it : activities) {
            urlMap.put((Long)it._2(), this.getUrlByType((Integer)it._1(), (Long)it._2()));
        }
        return urlMap;
    }

    private String getUrlByType(Integer type, Long operatingActivityId) {
        String url = null;
        if (0 == type) {
            url = String.format("%s/consumerDuibaActivity/list/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (2 == type || 3 == type) {
            url = String.format("%s/singleLottery/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (5 == type) {
            url = String.format("%s/ConsumerAppManualLottery/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (6 == type) {
            url = String.format("%s/shake/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (7 == type) {
            url = String.format("%s/ScratchCard/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (9 == type) {
            url = String.format("%s/tiger/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (11 == type) {
            url = String.format("%s/flop/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (12 == type) {
            url = String.format("%s/smashg/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (8 == type) {
            url = String.format("%s/turntableNew/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (40 == type) {
            url = String.format("%s/question/index?id=%s&dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (41 == type) {
            url = String.format("%s/quizz/index?id=%s&dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (30 == type) {
            url = String.format("%s/SecondsKillActivity/index?id=%s&dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (31 == type) {
            url = String.format("%s/seckill/index/%s?dbnewopen", DomainConfigureConstant.getAppDuibaSeckillDomainName(), operatingActivityId);
        } else if (28 == type) {
            url = String.format("%s/ngame/index?id=%s&dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        } else if (42 == type) {
            url = String.format("%s/guess/index?id=%s&dbnewopen", DomainConfigureConstant.getAppDuibaCreditsDomainName(), operatingActivityId);
        }
        return url;
    }

    @Override
    public OperatingActivityDto findAppActivity(Long appId, Long activityId, Integer type) {
        if (appId == null || activityId == null || type == null) {
            return null;
        }
        OperatingActivityEntity entity = this.operatingActivityDao.findByActivityIdAndTypeAndAppIdAndDeleted(activityId, type, appId, Boolean.FALSE);
        if (entity == null) {
            return null;
        }
        OperatingActivityDto dto = new OperatingActivityDto();
        BeanUtils.copy((Object)((Object)entity), (Object)dto);
        return dto;
    }

    @Override
    public List<OperatingActivityDto> findAppActivitys(Long appId, List<Tuple.Tuple2<Integer, Long>> activities) {
        if (appId == null || CollectionUtils.isEmpty(activities)) {
            return null;
        }
        ArrayList<OperatingActivityDto> result = new ArrayList<OperatingActivityDto>();
        OperatingActivityDto dto = null;
        OperatingActivityEntity entity = null;
        for (Tuple.Tuple2<Integer, Long> it : activities) {
            entity = this.operatingActivityDao.findByActivityIdAndTypeAndAppIdAndDeleted((Long)it._2(), (Integer)it._1(), appId, Boolean.FALSE);
            if (entity == null) continue;
            dto = new OperatingActivityDto();
            BeanUtils.copy((Object)((Object)entity), (Object)dto);
            result.add(dto);
        }
        return result;
    }
}

