/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.elasticgifts.impl;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppListDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsAppSaveResultDto;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsBizCodeEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsCommonAppEnum;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsAppDao;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsAppEntity;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsEntity;
import cn.com.duiba.activity.center.biz.remoteservice.impl.seconds_kill.RemoteSeckillAppOrderServiceImpl;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsAppService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="elasticGiftsAppService")
public class ElasticGiftsAppServiceImpl
implements ElasticGiftsAppService {
    private static Logger LOGGER = LoggerFactory.getLogger(RemoteSeckillAppOrderServiceImpl.class);
    public static final List<Long> APP_COMMON_LIST = Collections.singletonList(0L);
    @Autowired
    private ElasticGiftsAppDao elasticGiftsAppDao;
    @Autowired
    private ElasticGiftsDao elasticGiftsDao;
    @Autowired
    private RemoteAppService remoteAppService;

    @Override
    public List<ElasticGiftsAppListDto> getAllElasticGiftsApps(ElasticGiftsBizCodeEnum bizCode, Long activityId) {
        Preconditions.checkNotNull((Object)bizCode, (Object)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a null");
        List<ElasticGiftsAppEntity> entities = this.elasticGiftsAppDao.findAllByBizCodeAndElId(bizCode.value(), activityId);
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        ArrayListMultimap multimap = ArrayListMultimap.create();
        ElasticGiftsAppEntity common = null;
        for (ElasticGiftsAppEntity it : entities) {
            if (it.getAppId() == (long)ElasticGiftsCommonAppEnum.COMMON.value()) {
                common = it;
                continue;
            }
            multimap.put((Object)it.getElasticGiftsId(), (Object)it);
        }
        ArrayList<ElasticGiftsAppListDto> result = new ArrayList<ElasticGiftsAppListDto>();
        if (common != null) {
            ElasticGiftsEntity elcommon = this.elasticGiftsDao.find(common.getElasticGiftsId());
            ElasticGiftsAppListDto commonDto = new ElasticGiftsAppListDto();
            commonDto.setIds(Collections.singletonList(common.getId()));
            commonDto.setBizCode(common.getBizCode());
            commonDto.setTitle4admin(elcommon == null ? "" : elcommon.getTitle4admin());
            commonDto.setElasticGiftsId(Long.valueOf(elcommon == null ? 0L : elcommon.getId()));
            commonDto.setAppIdsStr(ElasticGiftsCommonAppEnum.COMMON.value() + "");
            commonDto.setAppIds(APP_COMMON_LIST);
            result.add(commonDto);
        }
        for (Long it : multimap.keySet()) {
            List ens = (List)multimap.get((Object)it);
            ElasticGiftsEntity el = this.elasticGiftsDao.find(it);
            ArrayList<Long> ids = new ArrayList<Long>();
            ArrayList<Long> appIds = new ArrayList<Long>();
            for (ElasticGiftsAppEntity en : ens) {
                ids.add(en.getId());
                appIds.add(en.getAppId());
            }
            ElasticGiftsAppListDto dto = new ElasticGiftsAppListDto();
            dto.setIds(ids);
            dto.setElasticGiftsId(el.getId());
            dto.setBizCode(el.getBizCode());
            dto.setTitle4admin(el.getTitle4admin());
            dto.setAppIds(appIds);
            dto.setAppIdsStr(Joiner.on((String)",").join(appIds));
            result.add(dto);
        }
        return result;
    }

    @Override
    public Boolean delete(ElasticGiftsBizCodeEnum bizCode, List<Long> appIds) throws Exception {
        Preconditions.checkNotNull((Object)bizCode, (Object)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(appIds), (Object)"appIds\u4e0d\u80fd\u4e3a null");
        if (appIds.contains(APP_COMMON_LIST.get(0))) {
            throw new Exception("\u5171\u4eab\u5e93\u4e0d\u80fd\u5220\u9664");
        }
        return this.elasticGiftsAppDao.deleteByBizCodeAndAppIds(bizCode.value(), appIds) > 0;
    }

    @Override
    public Boolean saveElasticGiftsIdByAppId(Long elasticGiftsId, Long appId, ElasticGiftsBizCodeEnum bizCode) {
        Preconditions.checkNotNull((Object)elasticGiftsId, (Object)"\u6d3b\u52a8 id\u4e0d\u80fd\u4e3a null");
        Preconditions.checkNotNull((Object)appId, (Object)"appId\u4e0d\u80fd\u4e3a null");
        Preconditions.checkNotNull((Object)bizCode, (Object)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a null");
        ElasticGiftsAppEntity entity = this.elasticGiftsAppDao.findByBizCodeAndAppId(bizCode.value(), appId);
        if (entity == null) {
            ElasticGiftsAppEntity e4i = new ElasticGiftsAppEntity();
            e4i.setElasticGiftsId(elasticGiftsId);
            e4i.setBizCode(bizCode.value());
            e4i.setAppId(appId);
            return this.elasticGiftsAppDao.insert(e4i) > 0;
        }
        return this.elasticGiftsAppDao.updateElasticGiftsIdByAppId(elasticGiftsId, appId, bizCode.value()) > 0;
    }

    @Override
    public List<ElasticGiftsAppSaveResultDto> save(List<Long> toDeleteIds, ElasticGiftsBizCodeEnum bizCode, List<Long> appIds, Long activityId) {
        Preconditions.checkNotNull((Object)bizCode, (Object)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a null");
        Preconditions.checkNotNull((Object)activityId, (Object)"\u6d3b\u52a8 id\u4e0d\u80fd\u4e3a null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(appIds), (Object)"appIds\u4e0d\u80fd\u4e3a null");
        boolean deleteResult = true;
        if (CollectionUtils.isNotEmpty(toDeleteIds)) {
            boolean bl = deleteResult = this.elasticGiftsAppDao.deleteByIds(toDeleteIds) > 0;
            if (!deleteResult && !appIds.contains(APP_COMMON_LIST.get(0))) {
                throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25,\u8bf7\u5148\u56de\u5230\u5217\u8868\u9875\u518d\u8fdb\u6765\u7f16\u8f91");
            }
        }
        ArrayList<ElasticGiftsAppSaveResultDto> result = new ArrayList<ElasticGiftsAppSaveResultDto>();
        if (appIds.contains(APP_COMMON_LIST.get(0))) {
            this.elasticGiftsAppDao.updateElasticGiftsIdByAppId(activityId, APP_COMMON_LIST.get(0), bizCode.value());
            return result;
        }
        for (Long it : appIds) {
            AppDO app = this.remoteAppService.find(it);
            if (app == null) {
                result.add(ElasticGiftsAppSaveResultDto.failReuslt((Long)it, (String)"app \u4e0d\u5b58\u5728"));
                continue;
            }
            try {
                ElasticGiftsAppEntity e4i = new ElasticGiftsAppEntity();
                e4i.setElasticGiftsId(activityId);
                e4i.setBizCode(bizCode.value());
                e4i.setAppId(it);
                int ret = this.elasticGiftsAppDao.insert(e4i);
                if (ret > 0) continue;
                throw new Exception("\u63d2\u5165\u5931\u8d25");
            }
            catch (Exception e) {
                LOGGER.error("\u4fdd\u5b58\u5931\u8d25", (Object)e.getMessage());
                result.add(ElasticGiftsAppSaveResultDto.failReuslt((Long)it, (String)"app \u5df2\u7ecf\u53c2\u4e0e\u5176\u4ed6\u6d3b\u52a8"));
            }
        }
        return result;
    }
}

