/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.elasticgifts.impl;

import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermDto;
import cn.com.duiba.activity.center.api.dto.elasticgifts.ElasticGiftsTermSimpleDto;
import cn.com.duiba.activity.center.api.enums.DeletedEnum;
import cn.com.duiba.activity.center.api.enums.ElasticGiftsTermTypeEnum;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsTermDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsTermEntity;
import cn.com.duiba.activity.center.biz.service.elasticgifts.ElasticGiftsTermService;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="elasticGiftsTermService")
public class ElasticGiftsTermServiceImpl
implements ElasticGiftsTermService {
    @Autowired
    private ElasticGiftsTermDao elasticGiftsTermDao;

    @Override
    public List<ElasticGiftsTermSimpleDto> getTermsByElasticGiftsId(Long elasticGiftsId) {
        Preconditions.checkNotNull((Object)elasticGiftsId, (Object)"\u6d3b\u52a8 id \u4e0d\u80fd\u4e3a null");
        List<ElasticGiftsTermEntity> entities = this.elasticGiftsTermDao.findAllByElId(elasticGiftsId);
        ArrayList<ElasticGiftsTermSimpleDto> result = new ArrayList<ElasticGiftsTermSimpleDto>();
        for (ElasticGiftsTermEntity it : entities) {
            result.add(new ElasticGiftsTermSimpleDto(it.getId(), it.getTermId(), it.getPayload()));
        }
        return result;
    }

    @Override
    public Boolean sortTerms(List<Long> ids) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids \u4e0d\u80fd\u4e3a null");
        int payload = 1;
        for (Long it : ids) {
            this.elasticGiftsTermDao.updatePayloadById(it, payload++);
        }
        return true;
    }

    @Override
    public Boolean delete(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id \u4e0d\u80fd\u4e3a null");
        return this.elasticGiftsTermDao.delete(id) > 0;
    }

    @Override
    public Boolean save(Long id, ElasticGiftsTermTypeEnum typeEnum, Long termId, Long elasticGiftsId, String title, String subtitle, String payIntro, String btnText) {
        Preconditions.checkNotNull((Object)typeEnum, (Object)"\u793c\u5305\u9879\u7c7b\u578b\u4e0d\u80fd\u4e3a null");
        Preconditions.checkNotNull((Object)termId, (Object)"\u793c\u5305\u9879id\u4e0d\u80fd\u4e3a null");
        Preconditions.checkNotNull((Object)elasticGiftsId, (Object)"\u793c\u5305id\u4e0d\u80fd\u4e3a null");
        if (this.isCreate(id)) {
            ElasticGiftsTermEntity e4i = new ElasticGiftsTermEntity();
            e4i.setPayload(this.elasticGiftsTermDao.getMaxPayload() + 1);
            e4i.setTermType(typeEnum.value());
            e4i.setTermId(termId);
            e4i.setElasticGiftsId(elasticGiftsId);
            e4i.setTitle(title);
            e4i.setSubtitle(subtitle);
            e4i.setPayIntro(payIntro);
            e4i.setBtnText(btnText);
            e4i.setDeleted(DeletedEnum.UNDELETED.value());
            return this.elasticGiftsTermDao.insert(e4i) > 0;
        }
        ElasticGiftsTermEntity e4u = new ElasticGiftsTermEntity();
        e4u.setId(id);
        e4u.setElasticGiftsId(elasticGiftsId);
        e4u.setTermType(typeEnum.value());
        e4u.setTermId(termId);
        e4u.setTitle(title);
        e4u.setSubtitle(subtitle);
        e4u.setPayIntro(payIntro);
        e4u.setBtnText(btnText);
        return this.elasticGiftsTermDao.update(e4u) > 0;
    }

    private boolean isCreate(Long id) {
        return id == null;
    }

    @Override
    public ElasticGiftsTermDto getTermById(Long id) {
        Preconditions.checkNotNull((Object)id, (Object)"id \u4e0d\u80fd\u4e3a null");
        ElasticGiftsTermEntity entity = this.elasticGiftsTermDao.find(id);
        Preconditions.checkNotNull((Object)entity, (Object)"term \u4e0d\u5b58\u5728");
        ElasticGiftsTermDto dto = new ElasticGiftsTermDto();
        BeanUtils.copyProperties((Object)entity, (Object)dto, (String[])new String[]{"termType", "deleted"});
        dto.setDeleted(DeletedEnum.fromValue((int)entity.getDeleted()));
        dto.setTermType(ElasticGiftsTermTypeEnum.fromValue((int)entity.getTermType()));
        return dto;
    }
}

