/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterHomeResourceListDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.ActivityShieldDao;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceDao;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceLocationDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceLocationEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.direct.DeveloperActBlackService;
import cn.com.duiba.activity.center.biz.service.direct.DuibaActivityAppSpecifyNewService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterHomeService;
import cn.com.duiba.activity.center.biz.service.gamecenter.impl.Utils;
import cn.com.duiba.activity.center.biz.service.littlegame.LittleGameService;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GameCenterHomeServiceImpl
implements GameCenterHomeService {
    private static final Logger log = LoggerFactory.getLogger(GameCenterHomeServiceImpl.class);
    @Resource
    private GameCenterResourceDao gameCenterResourceDao;
    @Resource
    private GameCenterResourceLocationDao gameCenterResourceLocationDao;
    @Resource
    private LittleGameService littleGameService;
    @Resource
    private ActivityShieldDao activityShieldDao;
    @Resource
    private RemoteAppService remoteAppService;
    @Resource
    private DeveloperActBlackService developerActBlackService;
    @Resource
    private DuibaActivityAppSpecifyNewService duibaActivityAppSpecifyNewService;

    @Override
    public GameCenterHomeResourceListDto findResourceByLocationAndAppId(String locationName, Long appId, Integer offset, Integer max) throws GameCenterException {
        GameCenterHomeResourceListDto gameCenterHomeResourceListDto = new GameCenterHomeResourceListDto();
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceByLocationId(this.findLocationIdByName(locationName));
        if (CollectionUtils.isEmpty(entities)) {
            return gameCenterHomeResourceListDto;
        }
        ArrayList<GameCenterHomeResourceDto> gameCenterHomeResourceDtoList = new ArrayList<GameCenterHomeResourceDto>();
        Long developerId = this.findDeveloperIdByAppId(appId);
        if (developerId == null) {
            return gameCenterHomeResourceListDto;
        }
        for (GameCenterResourceEntity gameCenterResourceEntity : entities) {
            LittleGameEntity littleGameEntity;
            if (gameCenterResourceEntity.getActivityType() != 47 || Utils.filterLittleGameByStatus(littleGameEntity = this.littleGameService.selectById(gameCenterResourceEntity.getActivityId()), gameCenterResourceEntity.getActivityId()) || littleGameEntity.isOpenSwitch(1) && this.filterByActivityBlacklist(gameCenterResourceEntity.getActivityId(), 47, developerId) || littleGameEntity.isOpenSwitch(0) && this.duibaActivityAppSpecifyNewService.findAppSpecifyByActivityIdAndAppIdAndActivityType(gameCenterResourceEntity.getActivityId(), appId, "littlegame") == null || this.hasShield(appId, 47, gameCenterResourceEntity.getActivityId())) continue;
            GameCenterHomeResourceDto temp = new GameCenterHomeResourceDto();
            temp.setActivityId(gameCenterResourceEntity.getActivityId());
            temp.setActivityType(gameCenterResourceEntity.getActivityType());
            temp.setGmtCreate(gameCenterResourceEntity.getGmtCreate());
            temp.setGmtModified(gameCenterResourceEntity.getGmtModified());
            temp.setLocationId(gameCenterResourceEntity.getResourceLocationId());
            temp.setTitle(littleGameEntity.getLittleGameTitle());
            temp.setDescription(littleGameEntity.getLittleGameRecomDescribe());
            temp.setBannerImg(littleGameEntity.getLittleGameBannerImg());
            temp.setRecommendImg(littleGameEntity.getLittleGameSmallImg());
            temp.setIconImg(littleGameEntity.getLittleGameIconImg());
            gameCenterHomeResourceDtoList.add(temp);
        }
        if (gameCenterHomeResourceDtoList.isEmpty()) {
            return gameCenterHomeResourceListDto;
        }
        Collections.sort(gameCenterHomeResourceDtoList, new Comparator<GameCenterHomeResourceDto>(){

            @Override
            public int compare(GameCenterHomeResourceDto o1, GameCenterHomeResourceDto o2) {
                return o1.getGmtModified().compareTo(o2.getGmtModified());
            }
        });
        gameCenterHomeResourceListDto.setCount(Integer.valueOf(gameCenterHomeResourceDtoList.size()));
        gameCenterHomeResourceListDto.setGameCenterHomeResourceDtoList(Utils.subList(gameCenterHomeResourceDtoList, offset, max));
        return gameCenterHomeResourceListDto;
    }

    private Long findLocationIdByName(String name) throws GameCenterException {
        GameCenterResourceLocationEntity entity = this.gameCenterResourceLocationDao.findResourceLocationByName(name);
        if (entity == null) {
            throw new GameCenterException("No this location found:" + name);
        }
        return entity.getId();
    }

    private boolean hasShield(Long appId, Integer activityType, Long activityId) {
        return this.activityShieldDao.findShield(appId, activityType, activityId) != null;
    }

    private boolean filterByActivityBlacklist(Long activityId, Integer activityType, Long developerId) {
        Boolean result = this.developerActBlackService.isExist(activityId, activityType, developerId);
        return result;
    }

    private Long findDeveloperIdByAppId(Long appId) {
        AppDO appDO = this.remoteAppService.find(appId);
        if (appDO == null) {
            log.error("appId is invalid: no record found: {}", (Object)appId);
            return null;
        }
        return appDO.getDeveloperId();
    }
}

