/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.gamecenter.impl;

import cn.com.duiba.activity.center.api.dto.gamecenter.GameCenterStatisticDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.LittleGameResourceListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.RelatedActivityDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.RelatedActivityListDto;
import cn.com.duiba.activity.center.api.dto.gamecenter.ShieldItemDto;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceDao;
import cn.com.duiba.activity.center.biz.dao.gamecenter.GameCenterResourceLocationDao;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceEntity;
import cn.com.duiba.activity.center.biz.entity.gamecenter.GameCenterResourceLocationEntity;
import cn.com.duiba.activity.center.biz.entity.littlegame.LittleGameEntity;
import cn.com.duiba.activity.center.biz.service.gamecenter.ActivityShieldService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterException;
import cn.com.duiba.activity.center.biz.service.gamecenter.GameCenterResourceService;
import cn.com.duiba.activity.center.biz.service.gamecenter.GeneralActivityItem;
import cn.com.duiba.activity.center.biz.service.gamecenter.MultiActivityQueryingService;
import cn.com.duiba.activity.center.biz.service.gamecenter.impl.Utils;
import cn.com.duiba.activity.center.biz.service.littlegame.LittleGameService;
import cn.com.duiba.wolf.utils.BeanUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GameCenterResourceServiceImpl
implements GameCenterResourceService {
    private static final Logger log = LoggerFactory.getLogger(GameCenterResourceServiceImpl.class);
    @Resource
    private GameCenterResourceDao gameCenterResourceDao;
    @Resource
    private GameCenterResourceLocationDao gameCenterResourceLocationDao;
    @Resource
    private MultiActivityQueryingService multiActivityQueryingService;
    @Resource
    private ActivityShieldService gameCenterShieldService;
    @Resource
    private LittleGameService littleGameService;
    private static final byte RESOURCE_NORMAL = 1;
    private static final byte RESOURCE_DELETED = 2;

    @Override
    public GameCenterStatisticDto findStatistic() throws GameCenterException {
        GameCenterStatisticDto littleGameResourceDtoList = new GameCenterStatisticDto();
        Integer littleGameCount = this.littleGameService.selectCountByStatus(1);
        littleGameResourceDtoList.setLittleGameCount(littleGameCount);
        Long bannerLocId = this.findLocationIdByName("Banner");
        List<GameCenterResourceEntity> bannerResourceEntities = this.gameCenterResourceDao.findResourceByLocationId(bannerLocId);
        littleGameResourceDtoList.setBannerLittleGameCount(Integer.valueOf(this.countLittleGame(bannerResourceEntities)));
        Long todayRecommendLocId = this.findLocationIdByName("TodayRecommend");
        List<GameCenterResourceEntity> todayRecommendResEntities = this.gameCenterResourceDao.findResourceByLocationId(todayRecommendLocId);
        littleGameResourceDtoList.setTodayRecommendCount(Integer.valueOf(this.countLittleGame(todayRecommendResEntities)));
        Long everyonePalyLocId = this.findLocationIdByName("EveryonePlay");
        List<GameCenterResourceEntity> everyonePlayResEntities = this.gameCenterResourceDao.findResourceByLocationId(everyonePalyLocId);
        littleGameResourceDtoList.setEveryonePlayCount(Integer.valueOf(this.countLittleGame(everyonePlayResEntities)));
        return littleGameResourceDtoList;
    }

    private int countLittleGame(List<GameCenterResourceEntity> gameCenterResourceEntities) {
        if (CollectionUtils.isEmpty(gameCenterResourceEntities)) {
            return 0;
        }
        int count = 0;
        for (GameCenterResourceEntity entity : gameCenterResourceEntities) {
            LittleGameEntity littleGameEntity;
            if (entity.getActivityType() != 47 || Utils.filterLittleGameByStatus(littleGameEntity = this.littleGameService.selectById(entity.getActivityId()), entity.getActivityId())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public LittleGameResourceListDto findLittleGameResource(Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = new LittleGameResourceListDto();
        littleGameResourceListDto.setCount(this.littleGameService.selectCountByStatus(1));
        List<LittleGameEntity> entities = this.littleGameService.selectListByStatus(1, offset, max);
        if (CollectionUtils.isEmpty(entities)) {
            return littleGameResourceListDto;
        }
        ArrayList<LittleGameResourceDto> littleGameResourceDtoList = new ArrayList<LittleGameResourceDto>();
        for (LittleGameEntity entity : entities) {
            LittleGameResourceDto temp = new LittleGameResourceDto();
            temp.setActivityId(entity.getId());
            temp.setTitle(entity.getLittleGameTitle());
            temp.setIconImg(entity.getLittleGameIconImg());
            temp.setGmtCreate(entity.getGmtCreate());
            temp.setGmtModified(entity.getGmtModified());
            this.setLocationsAndUpdateTime(temp);
            littleGameResourceDtoList.add(temp);
        }
        littleGameResourceListDto.setLittleGameResourceDtoList(littleGameResourceDtoList);
        return littleGameResourceListDto;
    }

    @Override
    public Boolean updateResourceLocation(Long activityId, Integer activityType, List<String> addLocationNames, List<String> delLocationNames) throws GameCenterException {
        if (CollectionUtils.isEmpty(addLocationNames) && CollectionUtils.isEmpty(delLocationNames)) {
            return true;
        }
        boolean result = true;
        if (!CollectionUtils.isEmpty(addLocationNames)) {
            for (String name : addLocationNames) {
                result = result && this.createGameCenterResource(activityType, activityId, name);
            }
        }
        if (!CollectionUtils.isEmpty(delLocationNames)) {
            for (String name : delLocationNames) {
                result = result && this.deleteGameCenterResource(activityType, activityId, name);
            }
        }
        return result;
    }

    private boolean createGameCenterResource(Integer activityType, Long activityId, String name) throws GameCenterException {
        Long locId = this.findLocationIdByName(name);
        GameCenterResourceEntity daoEntity = this.gameCenterResourceDao.findResource(activityType, activityId, locId);
        if (daoEntity != null) {
            return this.gameCenterResourceDao.updateStatus(daoEntity.getId(), (byte)1) == 1;
        }
        GameCenterResourceEntity entity = new GameCenterResourceEntity();
        entity.setActivityId(activityId);
        entity.setActivityType(activityType);
        entity.setResourceLocationId(locId);
        entity.setStatus((byte)1);
        entity.setPayload(0);
        Date now = new Date();
        entity.setGmtCreate(now);
        entity.setGmtModified(now);
        return this.gameCenterResourceDao.insert(entity) == 1;
    }

    private boolean deleteGameCenterResource(Integer activityType, Long activityId, String name) throws GameCenterException {
        Long locId = this.findLocationIdByName(name);
        GameCenterResourceEntity daoEntity = this.gameCenterResourceDao.findResource(activityType, activityId, locId);
        if (daoEntity == null) {
            return true;
        }
        return this.gameCenterResourceDao.updateStatus(daoEntity.getId(), (byte)2) == 1;
    }

    @Override
    public RelatedActivityListDto findRelatedActivity(Integer offset, Integer max) throws GameCenterException {
        RelatedActivityListDto relatedActivityListDto = new RelatedActivityListDto();
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceExcludeActivityType(47);
        if (CollectionUtils.isEmpty(entities)) {
            return relatedActivityListDto;
        }
        ArrayList<Object> relatedActivityDtoList = new ArrayList<Object>();
        for (GameCenterResourceEntity entity : entities) {
            GeneralActivityItem item;
            try {
                item = this.multiActivityQueryingService.findActivityByTypeAndIdWithFilter(entity.getActivityType(), entity.getActivityId());
            }
            catch (GameCenterException e) {
                log.info("Activity is not available: activityType={}, activityId={}", new Object[]{entity.getActivityType(), entity.getActivityId(), e});
                continue;
            }
            relatedActivityDtoList.add(BeanUtils.copy((Object)item, RelatedActivityDto.class));
        }
        relatedActivityListDto.setRelatedActivityDtoList(Utils.subList(relatedActivityDtoList, offset, max));
        relatedActivityListDto.setCount(Integer.valueOf(relatedActivityDtoList.size()));
        return relatedActivityListDto;
    }

    @Override
    public Boolean addRelatedActivity(Long activityId, Integer activityType) throws GameCenterException {
        this.multiActivityQueryingService.findActivityByTypeAndIdWithFilter(activityType, activityId);
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceByActivityTypeAndIdForEdit(activityType, activityId);
        Date now = new Date();
        if (CollectionUtils.isEmpty(entities)) {
            GameCenterResourceEntity entity = new GameCenterResourceEntity();
            entity.setActivityId(activityId);
            entity.setActivityType(activityType);
            entity.setPayload(0);
            entity.setResourceLocationId(this.findLocationIdByName("Banner"));
            entity.setStatus((byte)1);
            entity.setGmtCreate(now);
            entity.setGmtModified(now);
            return this.gameCenterResourceDao.insert(entity) == 1;
        }
        GameCenterResourceEntity entity = entities.get(0);
        if (entity.getStatus() == 1) {
            log.error(">>addRelatedActivity: resource does exist, nothing need to do.");
            return false;
        }
        return this.gameCenterResourceDao.updateStatus(entity.getId(), (byte)1) == 1;
    }

    @Override
    public Boolean deleteRelatedActivity(Long activityId, Integer activityType) {
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceByActivityTypeAndIdForEdit(activityType, activityId);
        if (CollectionUtils.isEmpty(entities)) {
            log.error(">>deleteRelatedActivity: resource does exist, nothing need to do.");
            return false;
        }
        GameCenterResourceEntity entity = entities.get(0);
        if (entity.getStatus() == 2) {
            log.error(">>deleteRelatedActivity: resource has deleted, nothing need to do.");
            return false;
        }
        return this.gameCenterResourceDao.updateStatus(entity.getId(), (byte)2) == 1;
    }

    @Override
    public LittleGameResourceListDto findAvailableLittleGameByAppId(Long appId, Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = new LittleGameResourceListDto();
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceByActivityType(47);
        if (CollectionUtils.isEmpty(entities)) {
            return littleGameResourceListDto;
        }
        ArrayList<LittleGameResourceDto> littleGameResourceDtoList = new ArrayList<LittleGameResourceDto>();
        for (GameCenterResourceEntity entity : entities) {
            LittleGameResourceDto temp = this.containsLittleGame(littleGameResourceDtoList, entity.getActivityId());
            if (temp != null) {
                temp.setGmtModified(Utils.latter(temp.getGmtModified(), entity.getGmtModified()));
                continue;
            }
            LittleGameEntity littleGameEntity = this.littleGameService.selectById(entity.getActivityId());
            if (Utils.filterLittleGameByStatus(littleGameEntity, entity.getActivityId())) continue;
            if (this.gameCenterShieldService.findShield(appId, 47, entity.getActivityId()) != null) {
                log.debug(">>findAvailableLittleGameByAppId: littleGame was filtered by shield. appid is {}, littleGameId is {}", (Object)appId, (Object)entity.getActivityId());
                continue;
            }
            temp = new LittleGameResourceDto();
            temp.setActivityId(entity.getActivityId());
            temp.setGmtCreate(entity.getGmtCreate());
            temp.setGmtModified(entity.getGmtModified());
            temp.setTitle(littleGameEntity.getLittleGameTitle());
            temp.setIconImg(littleGameEntity.getLittleGameIconImg());
            littleGameResourceDtoList.add(temp);
        }
        if (littleGameResourceDtoList.isEmpty()) {
            return littleGameResourceListDto;
        }
        Collections.sort(littleGameResourceDtoList, new Comparator<LittleGameResourceDto>(){

            @Override
            public int compare(LittleGameResourceDto o1, LittleGameResourceDto o2) {
                return o1.getGmtModified().compareTo(o2.getGmtModified());
            }
        });
        Collections.reverse(littleGameResourceDtoList);
        littleGameResourceListDto.setCount(Integer.valueOf(littleGameResourceDtoList.size()));
        littleGameResourceListDto.setLittleGameResourceDtoList(Utils.subList(littleGameResourceDtoList, offset, max));
        return littleGameResourceListDto;
    }

    @Override
    public LittleGameResourceListDto findHiddenLittleGameByAppId(Long appId, Integer offset, Integer max) {
        LittleGameResourceListDto littleGameResourceListDto = new LittleGameResourceListDto();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("activityType", 47);
        List<ShieldItemDto> shields = this.gameCenterShieldService.findShieldList(paramMap);
        if (CollectionUtils.isEmpty(shields)) {
            return littleGameResourceListDto;
        }
        ArrayList<LittleGameResourceDto> littleGameResourceDtoList = new ArrayList<LittleGameResourceDto>();
        for (ShieldItemDto item : shields) {
            LittleGameEntity littleGameEntity = this.littleGameService.selectById(item.getActivityId());
            if (Utils.filterLittleGameByStatus(littleGameEntity, item.getActivityId())) continue;
            LittleGameResourceDto temp = new LittleGameResourceDto();
            temp.setShieldId(item.getId());
            temp.setActivityType(Integer.valueOf(47));
            temp.setActivityId(item.getActivityId());
            temp.setGmtCreate(item.getGmtCreate());
            temp.setGmtModified(item.getGmtModified());
            temp.setTitle(littleGameEntity.getLittleGameTitle());
            temp.setIconImg(littleGameEntity.getLittleGameIconImg());
            littleGameResourceDtoList.add(temp);
        }
        if (littleGameResourceDtoList.isEmpty()) {
            return littleGameResourceListDto;
        }
        littleGameResourceListDto.setCount(Integer.valueOf(littleGameResourceDtoList.size()));
        littleGameResourceListDto.setLittleGameResourceDtoList(Utils.subList(littleGameResourceDtoList, offset, max));
        return littleGameResourceListDto;
    }

    private Long findLocationIdByName(String name) throws GameCenterException {
        GameCenterResourceLocationEntity entity = this.gameCenterResourceLocationDao.findResourceLocationByName(name);
        if (entity == null) {
            throw new GameCenterException("No this location found: " + name);
        }
        return entity.getId();
    }

    private void setLocationsAndUpdateTime(LittleGameResourceDto littleGameResourceDto) {
        List<GameCenterResourceEntity> entities = this.gameCenterResourceDao.findResourceByActivityTypeAndIdForEdit(littleGameResourceDto.getActivityType(), littleGameResourceDto.getActivityId());
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        ArrayList<String> locations = new ArrayList<String>();
        ArrayList<Date> gmtModifiedList = new ArrayList<Date>();
        for (GameCenterResourceEntity entity : entities) {
            if (entity.getStatus() != 1) continue;
            GameCenterResourceLocationEntity gameCenterResourceLocationEntity = this.gameCenterResourceLocationDao.find(entity.getResourceLocationId());
            if (gameCenterResourceLocationEntity == null) {
                log.error(">>findLocationsByActivityTypeAndId: no resource location found: " + entity.getResourceLocationId());
                continue;
            }
            gmtModifiedList.add(entity.getGmtModified());
            locations.add(gameCenterResourceLocationEntity.getTitle());
        }
        littleGameResourceDto.setLocations(locations);
        if (!gmtModifiedList.isEmpty()) {
            Collections.sort(gmtModifiedList);
            Collections.reverse(gmtModifiedList);
            littleGameResourceDto.setGmtModified((Date)gmtModifiedList.get(0));
        }
    }

    private LittleGameResourceDto containsLittleGame(List<LittleGameResourceDto> list, Long activityId) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (LittleGameResourceDto item : list) {
            if (!Objects.equals(item.getActivityId(), activityId)) continue;
            return item;
        }
        return null;
    }
}

