/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.manual.impl;

import cn.com.duiba.activity.center.api.dto.manual.ManualLotteryOrderDto;
import cn.com.duiba.activity.center.biz.dao.manuallottery.ManualOrderLotteryDao;
import cn.com.duiba.activity.center.biz.entity.manual.ManualLotteryOrderEntity;
import cn.com.duiba.activity.center.biz.service.manual.ManualOrderLotteryService;
import cn.com.duiba.activity.center.biz.support.copier.manual.ManualOrderLotteryCopier;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ManualOrderLotteryServiceImpl
implements ManualOrderLotteryService {
    @Resource
    private ManualOrderLotteryDao manualOrderLotteryDao;

    @Override
    public Integer countByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        Preconditions.checkNotNull((Object)consumerId);
        Preconditions.checkNotNull((Object)operatingActivityId);
        return this.manualOrderLotteryDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.manualOrderLotteryDao.countByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityId(Long consumerId, Long operatingActivityId) {
        return this.manualOrderLotteryDao.countByConsumerIdAndOperatingActivityId(consumerId, operatingActivityId);
    }

    @Override
    public Integer countFreeByConsumerIdAndOperatingActivityIdAndDate(Long consumerId, Long operatingActivityId, Date start, Date end) {
        return this.manualOrderLotteryDao.countFreeByConsumerIdAndOperatingActivityIdAndDate(consumerId, operatingActivityId, start, end);
    }

    @Override
    public List<ManualLotteryOrderDto> findAllOpenManualLotteryByCondition(Map<String, Object> paramMap) {
        List<ManualLotteryOrderEntity> entities = this.manualOrderLotteryDao.findAllOpenManualLotteryByCondition(paramMap);
        if (CollectionUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        List<ManualLotteryOrderDto> dtoList = ManualOrderLotteryCopier.entities2Dtos(entities);
        return dtoList;
    }

    @Override
    public Long findAllOpenManualLotteryCount(Map<String, Object> paramMap) {
        return this.manualOrderLotteryDao.findAllOpenManualLotteryCount(paramMap);
    }

    @Override
    public List<ManualLotteryOrderDto> findWardList(Long operatingActivityId) {
        List<ManualLotteryOrderEntity> wardList = this.manualOrderLotteryDao.findWardList(operatingActivityId);
        if (CollectionUtils.isEmpty(wardList)) {
            return Collections.emptyList();
        }
        return ManualOrderLotteryCopier.entities2Dtos(wardList);
    }

    @Override
    public List<ManualLotteryOrderDto> findNoWardList(Map<String, Object> paramMap) {
        List<ManualLotteryOrderEntity> noWardList = this.manualOrderLotteryDao.findNoWardList(paramMap);
        return ManualOrderLotteryCopier.entities2Dtos(noWardList);
    }

    @Override
    public Long findNoWardListCount(Map<String, Object> paramMap) {
        return this.manualOrderLotteryDao.findNoWardListCount(paramMap);
    }

    @Override
    public List<ManualLotteryOrderDto> findStartOpenListByIds(Map<String, Object> paramMap) {
        List<ManualLotteryOrderEntity> startOpenListByIds = this.manualOrderLotteryDao.findStartOpenListByIds(paramMap);
        return ManualOrderLotteryCopier.entities2Dtos(startOpenListByIds);
    }

    @Override
    public int updateAward(Long id, Long activityId, Date date) {
        return this.manualOrderLotteryDao.updateAward(id, activityId, date);
    }

    @Override
    public ManualLotteryOrderDto randomFindManualLottery(Map<String, Object> paramMap) {
        ManualLotteryOrderEntity entity = this.manualOrderLotteryDao.randomFindManualLottery(paramMap);
        return ManualOrderLotteryCopier.entity2Dto(entity);
    }

    @Override
    public void updateNoAwardList(Map<String, Object> paramMap) {
        this.manualOrderLotteryDao.updateNoAwardList(paramMap);
    }

    @Override
    public List<ManualLotteryOrderDto> findAllNoAwardList(Map<String, Object> paramMap) {
        List<ManualLotteryOrderEntity> allNoAwardList = this.manualOrderLotteryDao.findAllNoAwardList(paramMap);
        return ManualOrderLotteryCopier.entities2Dtos(allNoAwardList);
    }

    @Override
    public List<ManualLotteryOrderDto> findAllByIds(List<Long> ids) {
        List<ManualLotteryOrderEntity> allByIds = this.manualOrderLotteryDao.findAllByIds(ids);
        return ManualOrderLotteryCopier.entities2Dtos(allByIds);
    }

    @Override
    public ManualLotteryOrderDto findByOrderId(Long orderId) {
        ManualLotteryOrderEntity byOrderId = this.manualOrderLotteryDao.findByOrderId(orderId);
        return ManualOrderLotteryCopier.entity2Dto(byOrderId);
    }

    @Override
    public ManualLotteryOrderDto findByAppAndDeveloperBizId(Long appId, String bizId) {
        ManualLotteryOrderEntity orderEntity = this.manualOrderLotteryDao.findByAppAndDeveloperBizId(appId, bizId);
        return ManualOrderLotteryCopier.entity2Dto(orderEntity);
    }

    @Override
    public void insert(ManualLotteryOrderDto orderDTO) {
        ManualLotteryOrderEntity entity = (ManualLotteryOrderEntity)((Object)BeanUtils.copy((Object)orderDTO, ManualLotteryOrderEntity.class));
        this.manualOrderLotteryDao.insert(entity);
        orderDTO.setId(entity.getId());
    }

    @Override
    public void update(ManualLotteryOrderDto orderDTO) {
        ManualLotteryOrderEntity entity = ManualOrderLotteryCopier.dto2entity(orderDTO);
        this.manualOrderLotteryDao.update(entity);
    }

    @Override
    public ManualLotteryOrderDto find(Long id) {
        ManualLotteryOrderEntity entity = this.manualOrderLotteryDao.find(id);
        return ManualOrderLotteryCopier.entity2Dto(entity);
    }
}

