/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.plugin.impl;

import cn.com.duiba.activity.center.api.dto.plugin.ActivityPluginDto;
import cn.com.duiba.activity.center.biz.dao.plugin.ActivityPluginDao;
import cn.com.duiba.activity.center.biz.plugin.buckle.ConsumerPluginService;
import cn.com.duiba.activity.center.biz.plugin.event.DuibaEventsDispatcher;
import cn.com.duiba.activity.center.biz.plugin.event.order.ActivityOrdersEvent;
import cn.com.duiba.activity.center.biz.service.plugin.ActivityPluginService;
import cn.com.duiba.order.center.api.dto.ActivityOrderDto;
import cn.com.duiba.order.center.api.remoteservice.RemoteActivityOrderService;
import cn.com.duiba.service.domain.dataobject.ConsumerDO;
import cn.com.duiba.service.remoteservice.RemoteConsumerService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityPluginServiceImpl
implements ActivityPluginService {
    private static Logger log = LoggerFactory.getLogger(ActivityPluginServiceImpl.class);
    @Autowired
    private ActivityPluginDao activityPluginDao;
    @Autowired
    private RemoteConsumerService remoteConsumerService;
    @Autowired
    private RemoteActivityOrderService remoteActivityOrderService;
    @Autowired
    private ConsumerPluginService consumerPluginService;

    @Override
    public ActivityPluginDto createActivityPluginInfo(ActivityPluginDto activityPluginDto) {
        return this.activityPluginDao.createActivityPluginInfo(activityPluginDto);
    }

    @Override
    public Integer updateActivityPluginInfo(ActivityPluginDto activityPluginDto) {
        return this.activityPluginDao.updateActivityPluginInfo(activityPluginDto);
    }

    @Override
    public ActivityPluginDto findById(Long id) {
        return this.activityPluginDao.findById(id);
    }

    @Override
    public Integer OpenStatus(Long id, Integer value) {
        return this.activityPluginDao.OpenStatus(id, value);
    }

    @Override
    public List<ActivityPluginDto> findActivityPluginInfoList(Map<String, Object> map) {
        return this.activityPluginDao.findActivityPluginInfoList(map);
    }

    @Override
    public Long findPageCount(Map<String, Object> paramMap) {
        return this.activityPluginDao.findPageCount(paramMap);
    }

    @Override
    public Integer dellActivityPlugin(Long id) {
        return this.activityPluginDao.dellActivityPlugin(id);
    }

    @Override
    public int updateAutoOffDateNull(Date autoOffDate, Long id) {
        return this.activityPluginDao.updateAutoOffDateNull(autoOffDate, id);
    }

    @Override
    public String createOrder(Long consumerId, String transfer, String ip, String description, String ua, String os, ActivityPluginDto pluDto) {
        ConsumerDO consumer = this.remoteConsumerService.find(consumerId);
        String orderNum = this.createOrder(consumer, pluDto, ip);
        ActivityOrderDto order = (ActivityOrderDto)this.remoteActivityOrderService.findByOrderNum(orderNum).getResult();
        DuibaEventsDispatcher.get().dispatchEvent(new ActivityOrdersEvent(ActivityOrdersEvent.ActivityOrdersEventType.OnOrderCreate, order));
        this.consumerPluginService.asyncConsumerPlug(consumerId, orderNum, transfer, ip, ua, os, pluDto);
        return orderNum;
    }

    private String createOrder(ConsumerDO consumer, ActivityPluginDto pluDto, String ip) {
        ActivityOrderDto orderDto = new ActivityOrderDto();
        orderDto.setConsumerId(consumer.getId());
        orderDto.setAppId(consumer.getAppId());
        orderDto.setPartnerUserId(consumer.getPartnerUserId());
        orderDto.setDuibaActivityId(pluDto.getId());
        orderDto.setActivityType("plugin");
        orderDto.setConsumeCredits(Long.valueOf(0L));
        orderDto.setExchangeStatus(Integer.valueOf(1));
        orderDto.setConsumeCreditsStatus(Integer.valueOf(2));
        orderDto.setIp(ip);
        Date now = new Date();
        orderDto.setGmtCreate(now);
        orderDto.setGmtModified(now);
        String orderNum = null;
        try {
            orderNum = (String)this.remoteActivityOrderService.createOrder(orderDto).getResult();
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u8ba2\u5355\u5931\u8d25", (Throwable)e);
            throw e;
        }
        return orderNum;
    }
}

