/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.api.dto.rob.category.RobCategoryBarAppRelationDto;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarAppRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarDao;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarAppRelationEntity;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryBarAppRelationService;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RobCategoryBarAppRelationServiceImpl
implements RobCategoryBarAppRelationService {
    private static final Logger log = LoggerFactory.getLogger(RobCategoryBarAppRelationServiceImpl.class);
    @Autowired
    private RobCategoryBarAppRelationDao robCategoryBarAppDao;
    @Autowired
    private RobCategoryBarDao robCategoryBarDao;

    @Override
    public List<RobCategoryBarAppRelationDto> getRobCategoryBarAppList() {
        ArrayListMultimap barAppMultimap = ArrayListMultimap.create();
        List<RobCategoryBarAppRelationEntity> allList = this.robCategoryBarAppDao.getAllList();
        ArrayList<RobCategoryBarAppRelationDto> dtoList = new ArrayList<RobCategoryBarAppRelationDto>();
        if (CollectionUtils.isEmpty(allList)) {
            return dtoList;
        }
        for (RobCategoryBarAppRelationEntity entity : allList) {
            Long barId = entity.getBarId();
            barAppMultimap.put((Object)barId, (Object)entity);
        }
        ArrayList barIdList = Lists.newArrayList((Iterable)barAppMultimap.keySet());
        List<RobCategoryBarEntity> robCategoryBarEntityList = this.robCategoryBarDao.getByBarIds(barIdList);
        if (CollectionUtils.isEmpty(robCategoryBarEntityList)) {
            log.error("\u5206\u7c7b\u680f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5206\u7c7b\u680f\u4e0e\u5e94\u7528\u5173\u8054\u8868\u4e2d\u6570\u636e\u4e0e\u5206\u7c7b\u680f\u4e2d\u6570\u636e\u4e0d\u4e00\u81f4\u7684\u539f\u56e0!,barIdList=" + barIdList);
            return Collections.emptyList();
        }
        return this.assembleRobCategoryBarAppRelations(robCategoryBarEntityList, (Multimap<Long, RobCategoryBarAppRelationEntity>)barAppMultimap);
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean deleteById(Long barId) {
        int line = this.robCategoryBarAppDao.deleteByBarId(barId);
        return line > 0;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean batchDeleteById(List<Long> barIds) {
        if (CollectionUtils.isEmpty(barIds)) {
            return true;
        }
        return this.robCategoryBarAppDao.batchDeleteByBarId(barIds) > 0;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean batchInsertBarAppRelation(List<RobCategoryBarAppRelationDto> batchList) {
        for (RobCategoryBarAppRelationDto robCategoryBarAppRelationDto : batchList) {
            Long barId = robCategoryBarAppRelationDto.getBarId();
            Map appIdAndAppNameMap = robCategoryBarAppRelationDto.getAppIdAndAppNameMap();
            for (Map.Entry entry : appIdAndAppNameMap.entrySet()) {
                this.robCategoryBarAppDao.insert((Long)entry.getKey(), (String)entry.getValue(), barId);
            }
        }
        return true;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean batchUpdateBarAppRelation(List<RobCategoryBarAppRelationDto> batchList) {
        for (RobCategoryBarAppRelationDto relationDto : batchList) {
            Long barId = relationDto.getBarId();
            Map appIdAndAppNameMap = relationDto.getAppIdAndAppNameMap();
            if (CollectionUtils.isEmpty((Map)appIdAndAppNameMap)) {
                log.error("\u66f4\u65b0\u5b9a\u5411\u53c2\u6570\u4e2dapp\u6570\u636e\u4e3a\u7a7a");
                return false;
            }
            for (Map.Entry entry : appIdAndAppNameMap.entrySet()) {
                this.robCategoryBarAppDao.updateAppIdAndBarId((Long)entry.getKey(), (String)entry.getValue(), barId);
            }
        }
        return true;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean batchDeleteBarAppRelation(List<Long> appIds) {
        for (Long appId : appIds) {
            this.robCategoryBarAppDao.deleteByAppId(appId);
        }
        return true;
    }

    @Override
    public RobCategoryBarAppRelationEntity getByAppId(Long appId) {
        return this.robCategoryBarAppDao.getByAppId(appId);
    }

    private List<RobCategoryBarAppRelationDto> assembleRobCategoryBarAppRelations(List<RobCategoryBarEntity> robCategoryBarEntityList, Multimap<Long, RobCategoryBarAppRelationEntity> barAppMultimap) {
        ArrayList<RobCategoryBarAppRelationDto> relationDtoList = new ArrayList<RobCategoryBarAppRelationDto>(robCategoryBarEntityList.size());
        for (RobCategoryBarEntity robCategoryBarEntity : robCategoryBarEntityList) {
            Long barId = robCategoryBarEntity.getId();
            String barName = robCategoryBarEntity.getName();
            Collection relationEntities = barAppMultimap.get((Object)barId);
            HashMap<Long, String> appIdAndAppName = new HashMap<Long, String>();
            if (!relationEntities.isEmpty()) {
                for (RobCategoryBarAppRelationEntity relationEntity : relationEntities) {
                    appIdAndAppName.put(relationEntity.getAppId(), relationEntity.getAppName());
                }
            }
            relationDtoList.add(new RobCategoryBarAppRelationDto(barId, barName, appIdAndAppName));
        }
        return relationDtoList;
    }
}

