/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.rob.impl;

import cn.com.duiba.activity.center.api.dto.rob.category.RobBarCategoryRelationDto;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobBarCategoryRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarAppRelationDao;
import cn.com.duiba.activity.center.biz.dao.rob_category.RobCategoryBarDao;
import cn.com.duiba.activity.center.biz.entity.robcategory.RobCategoryBarEntity;
import cn.com.duiba.activity.center.biz.service.rob.RobCategoryBarService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RobCategoryBarServiceImpl
implements RobCategoryBarService {
    private static final Logger log = LoggerFactory.getLogger(RobCategoryBarServiceImpl.class);
    @Autowired
    private RobCategoryBarDao robCategoryBarDao;
    @Autowired
    private RobCategoryBarAppRelationDao robCategoryBarAppRelationDao;
    @Autowired
    private RobBarCategoryRelationDao robBarCategoryRelationDao;

    @Override
    public List<RobCategoryBarEntity> getAllCategoryBarList() {
        return this.robCategoryBarDao.getAllCategoryBarList();
    }

    @Override
    public List<RobCategoryBarEntity> getPagByName(String name, Integer offset, Integer pageSize) {
        if (offset == null || offset < 0) {
            offset = 0;
        }
        if (pageSize == null || pageSize < 1) {
            pageSize = 20;
        }
        return this.robCategoryBarDao.getPageByName(name, offset, pageSize);
    }

    @Override
    public Integer countByName(String name) {
        return this.robCategoryBarDao.countByName(name);
    }

    @Override
    public Boolean deleteBarById(Long barId) {
        if (barId.equals(1L)) {
            log.error("\u5171\u4eab\u5206\u7c7b\u680f\u4e0d\u80fd\u5220\u9664");
            return false;
        }
        this.transationDeleteByBarId(barId);
        return true;
    }

    @Override
    @Transactional(value="creditsActivity")
    public Boolean insertRobCategoryBar(String name, List<RobBarCategoryRelationDto> relationDtos) {
        Long barId = this.robCategoryBarDao.insertRobCategoryBar(new RobCategoryBarEntity(name));
        if (barId == null || barId < 1L) {
            return false;
        }
        if (!CollectionUtils.isEmpty(relationDtos)) {
            for (RobBarCategoryRelationDto robBarCategoryRelationDto : relationDtos) {
                this.robBarCategoryRelationDao.insertRobBar(barId, robBarCategoryRelationDto.getCategoryId(), robBarCategoryRelationDto.getPayload());
            }
        }
        return true;
    }

    @Override
    public RobCategoryBarEntity getRobCategoryBarById(Long barId) {
        return this.robCategoryBarDao.getById(barId);
    }

    @Override
    public List<Long> getRobCategoryIdsBarById(Long barId) {
        List<Long> categoryIds = this.robBarCategoryRelationDao.getRobCategoryIdsByBarId(barId);
        if (categoryIds == null) {
            categoryIds = new ArrayList<Long>();
        }
        return categoryIds;
    }

    @Transactional(value="creditsActivity")
    private void transationDeleteByBarId(Long barId) {
        this.robCategoryBarAppRelationDao.deleteByBarId(barId);
        this.robBarCategoryRelationDao.deleteByBarId(barId);
        this.robCategoryBarDao.deleteById(barId);
    }

    @Override
    public Boolean updateCategoryBar(Long barId, String name, List<RobBarCategoryRelationDto> relationDtos) {
        this.robCategoryBarDao.updateRobCategoryBar(barId, name);
        this.robBarCategoryRelationDao.deleteByBarId(barId);
        if (!CollectionUtils.isEmpty(relationDtos)) {
            for (RobBarCategoryRelationDto robBarCategoryRelationDto : relationDtos) {
                this.robBarCategoryRelationDao.insertRobBar(barId, robBarCategoryRelationDto.getCategoryId(), robBarCategoryRelationDto.getPayload());
            }
        }
        return true;
    }
}

