/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.seckill.impl;

import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillEntity;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillDateUtilService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import java.util.Calendar;
import java.util.Date;
import org.springframework.stereotype.Service;

@Service(value="seckillDateUtilService")
public class SeckillDateUtilServiceImpl
implements SeckillDateUtilService {
    @Override
    public boolean isNowDateOngoing(DuibaSeckillEntity duibaSeckill, Date now) {
        String startDay = DateUtil.getDayStr((Date)duibaSeckill.getDateStart());
        String endDay = DateUtil.getDayStr((Date)duibaSeckill.getDateEnd());
        Date start = DateUtil.getDayDate((String)startDay);
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDayDate((String)endDay));
        cal.add(5, 1);
        Date end = cal.getTime();
        return now.getTime() >= start.getTime() && now.getTime() <= end.getTime();
    }

    @Override
    public boolean isNowDateGoingStart(DuibaSeckillEntity duibaSeckill, Date now) {
        String startDay = DateUtil.getDayStr((Date)duibaSeckill.getDateStart());
        Date start = DateUtil.getDayDate((String)startDay);
        return System.currentTimeMillis() < start.getTime();
    }

    @Override
    public boolean isNowTimeGoingStart(DuibaSeckillEntity duibaSeckill, Date now) {
        String startTime = DateUtil.getMinuteOnlyStr((Date)duibaSeckill.getTimeStart());
        String nowTime = DateUtil.getMinuteOnlyStr((Date)now);
        return DateUtil.compareHHmmInString((String)nowTime, (String)startTime) < 0;
    }

    @Override
    public boolean isNowDateOver(DuibaSeckillEntity duibaSeckill, Date now) {
        String endDay = DateUtil.getDayStr((Date)duibaSeckill.getDateEnd());
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtil.getDayDate((String)endDay));
        cal.add(5, 1);
        Date end = cal.getTime();
        return System.currentTimeMillis() > end.getTime();
    }

    @Override
    public boolean isNowTimeOver(DuibaSeckillEntity duibaSeckill, Date now) {
        String nowTime;
        String endTime = DateUtil.getMinuteOnlyStr((Date)duibaSeckill.getTimeEnd());
        return DateUtil.compareHHmmInString((String)endTime, (String)(nowTime = DateUtil.getMinuteOnlyStr((Date)now))) < 0;
    }

    @Override
    public boolean isNowOngoing(DuibaSeckillEntity duibaSeckill, Date now) {
        String startTime = DateUtil.getMinuteOnlyStr((Date)duibaSeckill.getTimeStart());
        String endTime = DateUtil.getMinuteOnlyStr((Date)duibaSeckill.getTimeEnd());
        String nowTime = DateUtil.getMinuteOnlyStr((Date)now);
        return DateUtil.betweenHHmmInString((String)nowTime, (String)startTime, (String)endTime) == 1;
    }

    @Override
    public boolean isNowOneHourOngoing(DuibaSeckillEntity duibaSeckill, Date now) {
        if (this.isNowOngoing(duibaSeckill, now)) {
            return true;
        }
        String nowTime = DateUtil.getMinuteOnlyStr((Date)now);
        String oneHourAfterNowTime = DateUtil.getHour((String)nowTime) + 1 + ":" + DateUtil.getMinute((String)nowTime);
        String startTime = DateUtil.getMinuteOnlyStr((Date)duibaSeckill.getTimeStart());
        return DateUtil.compareHHmmInString((String)nowTime, (String)startTime) <= 0 && DateUtil.compareHHmmInString((String)oneHourAfterNowTime, (String)startTime) >= 0;
    }

    @Override
    public boolean isNowBeforeAfter5Min(DuibaSeckillEntity duibaSeckill, Date now) {
        String startTime = DateUtil.getMinuteOnlyStr((Date)DateUtil.minutesAddOrSub((Date)duibaSeckill.getTimeStart(), (int)-5));
        String endTime = DateUtil.getMinuteOnlyStr((Date)DateUtil.minutesAddOrSub((Date)duibaSeckill.getTimeEnd(), (int)5));
        String nowTime = DateUtil.getMinuteOnlyStr((Date)now);
        return DateUtil.betweenHHmmInString((String)nowTime, (String)startTime, (String)endTime) == 1;
    }
}

