/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.seckill.impl;

import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigEntity;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillMemcacheService;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillStockService;
import cn.com.duiba.activity.center.biz.service.seckill.impl.SeckillServiceImpl;
import cn.com.duiba.activity.center.common.util.DateUtil;
import cn.com.duiba.service.remoteservice.RemoteAppService;
import cn.com.duiba.wolf.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="seckillMemcacheService")
public class SeckillMemcacheServiceImpl
implements SeckillMemcacheService {
    private static Logger LOGGER = LoggerFactory.getLogger(SeckillServiceImpl.class);
    @Autowired
    private RemoteAppService remoteAppService;
    @Autowired
    private CacheClient memcachedClient;
    @Autowired
    private SeckillStockService seckillStockService;

    private String getStockKey(Long stockId) {
        return "seckill-2-" + stockId;
    }

    @Override
    public Long getMemcachedStockById(Long stockId, Long duibaSeckillId, Long appId) {
        String stock = (String)this.memcachedClient.get(this.getStockKey(stockId));
        if (stock == null) {
            DuibaSeckillStockConfigEntity stockConfig = this.seckillStockService.findStockByUnique(duibaSeckillId, appId);
            Integer exp = DateUtil.getToTomorrowSeconds();
            try {
                this.memcachedClient.add(this.getStockKey(stockConfig.getId()), exp.intValue(), (Object)(stockConfig.getStock() + ""));
            }
            catch (Exception e) {
                LOGGER.error("getMemcachedStockById memcachedClient.add error", (Throwable)e);
            }
            return (long)stockConfig.getStock();
        }
        return Long.valueOf(stock.trim());
    }

    @Override
    public void invalidateStockCacheById(Long stockId) {
        this.memcachedClient.remove(this.getStockKey(stockId));
    }
}

