/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.activity.center.biz.service.seckill.impl;

import cn.com.duiba.activity.center.biz.dao.seckill.DuibaSeckillStockConfigDao;
import cn.com.duiba.activity.center.biz.dao.seckill.DuibaSeckillStockConfigLogDao;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigConsumeEntity;
import cn.com.duiba.activity.center.biz.entity.seckill.DuibaSeckillStockConfigEntity;
import cn.com.duiba.activity.center.biz.service.seckill.SeckillStockService;
import cn.com.duiba.activity.center.common.util.DateUtil;
import com.google.common.base.Objects;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="seckillStockService")
public class SeckillStockServiceImpl
implements SeckillStockService {
    @Autowired
    private DuibaSeckillStockConfigDao duibaSeckillStockConfigDAO;
    @Autowired
    private DuibaSeckillStockConfigLogDao duibaSeckillStockConfigLogDAO;

    @Override
    public DuibaSeckillStockConfigEntity findStockByUnique(Long skillId, Long appId) {
        Date now = DateUtil.getDayDate((Date)new Date());
        DuibaSeckillStockConfigEntity stock = this.duibaSeckillStockConfigDAO.findByUnique(skillId, appId);
        if (stock != null) {
            if (now.equals(stock.getDay())) {
                return stock;
            }
            stock.setStock(0);
            return stock;
        }
        DuibaSeckillStockConfigEntity sharingStock = this.duibaSeckillStockConfigDAO.findByUnique(skillId, 0L);
        if (now.equals(sharingStock.getDay())) {
            return sharingStock;
        }
        sharingStock.setStock(0);
        return sharingStock;
    }

    @Override
    public DuibaSeckillStockConfigEntity findStock(Long stockId) {
        return this.duibaSeckillStockConfigDAO.find(stockId);
    }

    @Override
    public void consumeStock(Long stockId, Long orderId) throws Exception {
        DuibaSeckillStockConfigEntity stock = this.duibaSeckillStockConfigDAO.findForUpdate(stockId);
        if (Objects.equal(null, (Object)stock)) {
            throw new Exception("\u65e0\u5bf9\u5e94\u5e93\u5b58");
        }
        Date now = DateUtil.getDayDate((Date)new Date());
        if (!Objects.equal((Object)now.getTime(), (Object)stock.getDay().getTime())) {
            throw new Exception("\u5e93\u5b58\u5931\u6548");
        }
        if (stock.getStock() <= 0) {
            throw new Exception("\u5e93\u5b58\u4e0d\u8db3");
        }
        DuibaSeckillStockConfigConsumeEntity newlog = new DuibaSeckillStockConfigConsumeEntity();
        newlog.setAction("pay");
        newlog.setStockConfigId(stockId);
        newlog.setQuantity(-1);
        newlog.setBeforeVal(stock.getStock());
        newlog.setAfterVal(stock.getStock() - 1);
        newlog.setRelationType(DuibaSeckillStockConfigConsumeEntity.RelationType_Order);
        newlog.setRelationId(orderId);
        this.duibaSeckillStockConfigLogDAO.insertConsumeLog(newlog);
        int ret = this.duibaSeckillStockConfigDAO.consumeStock(stockId);
        if (ret <= 0) {
            throw new Exception("\u5e93\u5b58\u4e0d\u8db3");
        }
    }
}

