/**
 * Project Name:activity-center-biz
 * File Name:TodayRobSeckillBo.java
 * Package Name:cn.com.duiba.activity.center.biz.bo
 * Date:2016年9月30日上午9:40:50
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.bo.rob;

import java.util.List;

import cn.com.duiba.activity.center.api.dto.PaginationDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillAppDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillConfigDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillDto;
import cn.com.duiba.activity.center.api.dto.rob.TodayRobSeckillListDto;

/**
 * 今日必抢秒杀相关服务
 * Date:     2016年9月30日 上午9:40:50 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface TodayRobSeckillBo {

    /**
     * 
     * 推送秒杀活动到开发者库（operating_activity）</br>
     * <b>使用场景：</b>
     * <ul>
     *  <li>秒杀区间开启时</li>
     *  <li>秒杀区间编辑保存，并且区间为开启状态</li>
     *  <li>app列表更新时，将开启的活动全量推送给新增的app</li>
     * </ul>
     *
     * @author zhanglihui
     * @param activityList  兑吧秒杀活动列表
     * @param appIdList     需要推送的应用ID列表
     * @since JDK 1.6
     */
	void pushSeckillActivity(List<TodayRobSeckillConfigDto> activityIdList, List<Long> appIdList);
    /**
     * 秒杀配置插入
     * @param list
     * @param todayRobSeckillDto
     * @return
     */
    public Boolean seveSeckillConfigs(List<TodayRobSeckillConfigDto> list,TodayRobSeckillDto todayRobSeckillDto);
    /**
     * 管理端列表查询
     * @param pageNum
     * @param pageSize
     * @return
     */
    public PaginationDto<TodayRobSeckillListDto> findTodayRobSeckillList(int pageNum, int pageSize);
    
    /**
     * 根据appId查询对应的秒杀区间和秒杀活动
     *
     * @author zhanglihui
     * @param appId
     * @param showEntrance 
     * @return
     * @since JDK 1.6
     */
    List<TodayRobSeckillAppDto> findSeckillListByApp(Long appId, String showEntrance);
    
    
    /**
     * 停用/启用秒杀区间
     * 启动时，需要扫描秒杀活动是否推送过，没有推送需要推送到开发库
     *
     * @param todayRobSeckillId 秒杀区间ID
     * @param enable  true-启用；false-停用
     * @return
     */
    Boolean enableTodayRobSeckill(long todayRobSeckillId, boolean enable);
}

