/**
 * Project Name:activity-center-biz
 * File Name:ActivityCategoryRelation.java
 * Package Name:cn.com.duiba.activity.center.biz.dao.category
 * Date:2016年6月8日下午3:43:02
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.activity.center.biz.dao.category;

import java.util.List;

import cn.com.duiba.activity.center.biz.entity.ActivityCategoryRelationEntity;

/**
 * ClassName:ActivityCategoryRelation <br/>
 * Date:     2016年6月8日 下午3:43:02 <br/>
 * @author   wubo
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ActivityCategoryRelationDao {
    List<ActivityCategoryRelationEntity> selectByAppCategory(long appId, long categoryId);
    
    int updatePayload(long id, int payload);
    
    int insert(ActivityCategoryRelationEntity entity);
    
    int deleteByOperatingActivityId(long operatingActivityId);
    
    ActivityCategoryRelationEntity select(long id);
    
    List<ActivityCategoryRelationEntity> selectWithConditions(ActivityCategoryRelationEntity entity);

	List<ActivityCategoryRelationEntity> selectByAppCategory(long appId, long categoryId, int start, int pageSize);

    int deleteByOperatingActivityIdList(List<Long> operatingActivityIdList);
    
    int findMaxPlayload(long appId, long categoryId);
}

