package cn.com.duiba.activity.center.biz.dao.chaos;

import cn.com.duiba.activity.center.biz.entity.chaos.ActPreStockEntity;

import java.util.List;

/**
 * Created by yansen on 16/6/22.
 */
public interface ActPreStockDao {
	
	/**
	 * 根据奖品类型及id查询活动预分配定向库存
	 * @param relationPrizeId
	 * @param relationType
	 * @param appId
	 * @return
	 */
    public ActPreStockEntity findPreStockByApp(Long relationPrizeId, String relationType, Long appId);
    
    /**
     * 根据奖品类型及id查询活动预分配定向库存
     * @param relationPrizeIds
     * @param relationType
     * @param appId
     * @return
     */
    public List<ActPreStockEntity> findPreStockListByApp(List<Long> relationPrizeIds, String relationType, Long appId);

    /*
     * 根据奖品类型及id查询活动预分配共享库存
     * @param relationPrizeId
     * @param relationType
     * @return
     */
    public ActPreStockEntity findPreStockByShare(Long relationPrizeId, String relationType);

    /*
     * 加锁查询
     * @param id
     * @return
     */
    public ActPreStockEntity findByLock(Long id);

    /*
     * 减库存
     * @param id
     * @return
     */
    public int decrementRemaining(Long id);

    /*
     * 返库存
     * @param id
     * @return
     */
    public int incrementRemaining(Long id);

    /*
     * 加库存
     * @param id
     * @param addRemaining
     * @return
     */
    public int addRemainingById(Long id, Long addRemaining);

    /*
     * 减库存
     * @param id
     * @param subRemaining
     * @return
     */
    public int subRemainingById(Long id, Long subRemaining);

    /*
     * 插入记录
     * @param ActPreStockEntity
     */
    public void insert(ActPreStockEntity ActPreStockEntity);

    /*
     * 更新记录
     * @param ActPreStockEntity
     */
    public int update(ActPreStockEntity ActPreStockEntity);


    public int deleteActStock(Long configId, String relationType);

    public int deleteActPrizeStock(Long configId, Long prizeId, String relationType);

    public int deleteActStockAppId(Long prizeId, String relationType, Long appId);

    public List<ActPreStockEntity> findActStockByConfigId(Long configId, String relationType);
    
    public ActPreStockEntity find(Long id);
}
