package cn.com.duiba.activity.center.biz.dao.duibaactivity.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.duibaactivity.DuibaActivityDao;
import cn.com.duiba.activity.center.biz.entity.AddActivityEntity;
import cn.com.duiba.activity.center.biz.entity.duibaactivity.DuibaActivityEntity;
import org.springframework.stereotype.Repository;

import java.util.*;

/**
 * Created by yansen on 16/6/23.
 */
@Repository
public class DuibaActivityDaoImpl extends ActivityBaseDao implements DuibaActivityDao {

    @Override
    public List<DuibaActivityEntity> findPage(Map<String, Object> queryMap) {
        return selectList("findPage",queryMap);
    }

    @Override
    public List<DuibaActivityEntity> findDuibaActivity(Map<String, Object> queryMap) {
        return selectList("findDuibaActivity",queryMap);
    }

    @Override
    public Integer findPageCount(Map<String, Object> queryMap) {
        return selectOne("findPageCount",queryMap);
    }

    @Override
    public Integer getCountDuibaActivity(Map<String, Object> queryMap) {
        return selectOne("getCountDuibaActivity",queryMap);
    }

    @Override
    public List<AddActivityEntity> findAllDuibaActivity(Long appId) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        return selectList("findAllDuibaActivity",paramMap);
    }

    @Override
    public List<DuibaActivityEntity> findAllByIds(List<Long> ids) {
        if(ids == null || ids.isEmpty()){
            return new ArrayList<>();
        }
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("ids", ids);
        return selectList("findAllByIds",paramMap);
    }

    @Override
    public DuibaActivityEntity find(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return selectOne("find",paramMap);
    }

    @Override
    public void insert(DuibaActivityEntity duibaActivityDO) {
        insert("insert",duibaActivityDO);
    }

    @Override
    public void update(DuibaActivityEntity duibaActivityDO) {
        update("update", duibaActivityDO);
    }

    @Override
    public List<DuibaActivityEntity> findAutoOff() {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(new Date());
        cal1.add(Calendar.DATE, -1);
        Date startTime = cal1.getTime();

        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", new Date());
        return selectList("findAutoOff", paramMap);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        Map<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        return update("updateAutoOffDateNull",paramMap);
    }


    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
