package cn.com.duiba.activity.center.biz.dao.elasticgifts;

import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsTermEntity;

import java.util.List;

/**
 * 弹层礼包项
 */
public interface ElasticGiftsTermDao {

    /**
     * 根据 ids 批量获取
     * 不包含 deleted
     * @param ids
     * @return
     */
    List<ElasticGiftsTermEntity> findAllByIds(List<Long> ids);

    /**
     * 获取弹层礼包的未删除礼包项
     * @param elasticGiftsId
     * @return
     */
    List<ElasticGiftsTermEntity> findAllByElId(Long elasticGiftsId);

    /**
     * 删除
     * @param elasticGiftsId
     * @return
     */
    int deleteByElId(Long elasticGiftsId);

    /**
     * 插入
     * @param entity
     * @return
     */
    int insert(ElasticGiftsTermEntity entity);

    /**
     * 删除
     * @param id
     * @return
     */
    int delete(Long id);

    /**
     * 更新
     * @param id
     * @return
     */
    int update(ElasticGiftsTermEntity entity);

    /**
     * 根据 id 查询
     * @param id
     * @return
     */
    ElasticGiftsTermEntity find(Long id);

    /**
     * 更新排序
     * @param id
     * @param payload
     * @return
     */
    int updatePayloadById(Long id, Integer payload);

    /**
     * 获取最大权重
     * @return
     */
    Integer getMaxPayload();
}
