package cn.com.duiba.activity.center.biz.dao.elasticgifts.impl;

import cn.com.duiba.activity.center.biz.dao.ActivityBaseDao;
import cn.com.duiba.activity.center.biz.dao.DatabaseSchema;
import cn.com.duiba.activity.center.biz.dao.elasticgifts.ElasticGiftsAppDao;
import cn.com.duiba.activity.center.biz.entity.elasticgifts.ElasticGiftsAppEntity;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository("elasticGiftsAppDao")
public class ElasticGiftsAppDaoImpl extends ActivityBaseDao implements ElasticGiftsAppDao {

    @Override
    public List<Long> getAppIdsByElasticGiftsId(Long elasticGiftsId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("elasticGiftsId", elasticGiftsId);
        return this.selectList("getAppIdsByElasticGiftsId", paramMap);
    }

    @Override
    public List<ElasticGiftsAppEntity> findAllByBizCodeAndElId(Integer bizCode, Long elasticGiftsId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bizCode", bizCode);
        paramMap.put("elasticGiftsId", elasticGiftsId);
        return this.selectList("findAllByBizCodeAndElId", paramMap);
    }

    @Override
    public int deleteByBizCodeAndAppIds(Integer bizCode, List<Long> appIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bizCode", bizCode);
        paramMap.put("appIds", appIds);
        return this.delete("deleteByBizCodeAndAppIds", paramMap);
    }

    @Override
    public int deleteByIds(List<Long> ids) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("ids", ids);
        return this.delete("deleteByIds", paramMap);
    }

    @Override
    public int insert(ElasticGiftsAppEntity entity) {
        return this.insert("insert", entity);
    }

    @Override
    public ElasticGiftsAppEntity findByBizCodeAndAppId(Integer bizCode, Long appId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bizCode", bizCode);
        paramMap.put("appId", appId);
        return this.selectOne("findByBizCodeAndAppId", paramMap);
    }

    @Override
    public int updateElasticGiftsIdByAppId(Long elasticGiftsId, Long appId, Integer bizCode) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bizCode", bizCode);
        paramMap.put("elasticGiftsId", elasticGiftsId);
        paramMap.put("appId", appId);
        return this.update("updateElasticGiftsIdByAppId", paramMap);
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS_ACTIVITY;
    }
}
