/**
 * Project Name:activity-center-biz File Name:ActivityShieldDao.java Package
 * Name:cn.com.duiba.activity.center.biz.dao.gamecenter Date:2016年10月20日上午11:27:44 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.activity.center.biz.dao.gamecenter;

import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.activity.center.biz.entity.gamecenter.ActivityShieldEntity;

/**
 * ClassName:ActivityShieldDao <br/>
 * Function: 活动屏蔽dao层定义. <br/>
 * Reason: TODO ADD REASON. <br/>
 * Date: 2016年10月20日 上午11:27:44 <br/>
 *
 * @author zhuzhiyong
 * @version
 * @see
 * @since JDK 1.6
 */
public interface ActivityShieldDao {

    /**
     * 插入屏蔽记录.
     *
     * @param entity the entity
     * @return the int
     */
    Long insert(ActivityShieldEntity entity);

    /**
     * 根据主键删除屏蔽记录.
     *
     * @param id the id
     * @return the int
     */
    int delete(Long id);

    /**
     * 根据主键查询屏蔽记录.
     *
     * @param id the id
     * @return the activity shield entity
     */
    ActivityShieldEntity find(Long id);

    /**
     * 根据appId，activityType和activityId组合查询屏蔽记录.
     *
     * @param appId APP ID
     * @param activityType 活动类型，可以是小游戏，或者其他游戏，常量定义见{@code DefinedActivityTypesDto}
     * @param activityId the activity id
     * @return the activity shield entity
     */
    ActivityShieldEntity findShield(Long appId, Integer activityType, Long activityId);

    /**
     * 根据appId，activityType和activityId组合查询屏蔽记录.
     *
     * @param appId APP ID
     * @param activityType 活动类型，可以是小游戏，或者其他游戏，常量定义见{@code DefinedActivityTypesDto}
     * @param activityIds the activity ids
     * @return the activity shield entity
     */
    List<ActivityShieldEntity> findShields(Long appId, Integer activityType, Set<Long> activityIds);

    /**
     * findShieldList:查询屏蔽列表，支持分页，支持按指定字段过滤. <br/>
     * 分页参数：offset, max <br>
     * 支持单独参数过滤：appId <br>
     * 支持组合参数过滤：appId & activityType <br>
     * 活动类型activityType定义常量定义见{@code DefinedActivityTypesDto}<br>
     * 
     * @author zhuzhiyong
     * @param paramMap the param map
     * @return the list
     */
    List<ActivityShieldEntity> findShieldList(Map<String, Object> paramMap);

    /**
     * countShield:查询指定条件的记录数. <br/>
     * 支持单独参数过滤：appId, developerId <br>
     * 支持组合参数过滤：appId & activityType <br>
     * 活动类型activityType定义常量定义见{@code DefinedActivityTypesDto}<br>
     *
     * @param paramMap the param map
     * @return the integer
     */
    Integer countShield(Map<String, Object> paramMap);
}
